package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.api.v1.EnvironmentStageApi
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentStageFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class EnvironmentStageFilterGeneratorHandler(
                                              environmentStageApi: EnvironmentStageApi
                                            ) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[EnvironmentStageFilter]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val filter = ci.asInstanceOf[EnvironmentStageFilter]

    if (filter.getEnvironmentStageId != null) {
      val env = environmentStageApi.getById(filter.getEnvironmentStageId)
      filter.setEnvironmentStageId(env.getTitle)
    }
  }
}
