package com.xebialabs.xlrelease.ascode.yaml.writer

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.writer.{DefinitionWriter, GenerateContext, SpecWriter}
import com.xebialabs.xlrelease.ascode.yaml.model.ImportsSpec

object ImportsSpecWriter extends SpecWriter {
  override def write(spec: Spec, yamlGenerator: YAMLGenerator)(implicit mapper: ObjectMapper, config: DefinitionWriter.WriterConfig): GenerateContext = {
    val importSpec = spec.asInstanceOf[ImportsSpec]
    mapper.writeValue(yamlGenerator, importSpec)
    GenerateContext(Nil, Map.empty)
  }
}
