package com.xebialabs.xlrelease.ascode.helper

import com.xebialabs.deployit.checks.Checks.checkArgument
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.api.v1.TeamFacade
import com.xebialabs.xlrelease.api.v1.views.TeamView
import com.xebialabs.xlrelease.domain.Team
import com.xebialabs.xlrelease.repository.Ids.isNullId
import com.xebialabs.xlrelease.repository.TeamRepository
import com.xebialabs.xlrelease.service.{CiIdService, TeamService}
import com.xebialabs.xlrelease.views.converters.TeamViewConverter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import org.springframework.util.StringUtils

import java.util
import java.util.stream.Collectors
import scala.jdk.CollectionConverters._

@Service
class PermissionAsCodeHelper @Autowired()(teamService: TeamService,
                                          teamRepository: TeamRepository,
                                          ciIdService: CiIdService,
                                          teamViewConverter: TeamViewConverter,
                                          teamFacade: TeamFacade) {


  def getTeams(containerId: String): util.List[TeamView] =
    teamService.getPublicTeamViews(containerId)

  def deleteAndUpdateFromTeamView(folderId: String, updateTeamView: util.List[TeamView], toBeRemovedTeamViewForUpdate: util.List[TeamView]) = {

    teamFacade.checkPermissions(updateTeamView)
    val updateTeams = updateTeamView.stream().map(view => teamViewConverter.toTeam(view)).collect(Collectors.toList[Team])
    val toBeRemovedTeamForUpdate = toBeRemovedTeamViewForUpdate.stream().map(view => teamViewConverter.toTeam(view)).collect(Collectors.toList[Team])
    deleteAndUpdateTeams(folderId, updateTeams, toBeRemovedTeamForUpdate).stream
      .map(team => teamViewConverter.toView(team)).collect(Collectors.toList[TeamView])
  }

  private def deleteAndUpdateTeams(containerId: String, teamsAsCode: util.List[Team],toBeRemovedTeamFromUpdate: util.List[Team]): util.List[Team] = {

    val systemTeams = Set(Team.FOLDER_OWNER_TEAMNAME, Team.RELEASE_ADMIN_TEAMNAME, Team.TEMPLATE_OWNER_TEAMNAME)

    val teamNamesToBeRemoved = toBeRemovedTeamFromUpdate.asScala.filter(team => !systemTeams.contains(team.getTeamName)).map(team => team.getTeamName)

    val finalAsCodeTeamsUpdate = teamsAsCode.asScala.
                                  filter(team => !teamNamesToBeRemoved.contains(team.getTeamName)).toList

    finalAsCodeTeamsUpdate.foreach(team => {
      checkArgument(StringUtils.hasText(team.getTeamName), "Team name cannot be Empty/Blank")
      team.setTeamName(team.getTeamName.trim())
      generateIdIfNecessary(containerId, team)
    })
    teamRepository.saveTeamsToPlatform(containerId, finalAsCodeTeamsUpdate.asJava)
  }

  private def generateIdIfNecessary(containerId: String, team: Team): Unit = {
    if (isNullId(team.getId)) team.setId(ciIdService.getUniqueId(Type.valueOf(classOf[Team]), containerId))
  }

}
