/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService$;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import com.xebialabs.xlrelease.versioning.ascode.ValidationMessage;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001B\u000f\u001f\u0001%B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\")!\u000f\u0001C\u0001g\"9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!a \u0001\t\u0013\t\t\tC\u0005\u0002*\u0002\t\n\u0011\"\u0003\u0002,\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAe\u0001\u0011%\u00111\u001a\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDq!a;\u0001\t\u0013\ti\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002!9!\u0011\u0003\u0001\u0005\n\tM\u0001b\u0002B\r\u0001\u0011%!1\u0004\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqAa\u000b\u0001\t\u0013\u0011iC\u0001\u000bUe&<w-\u001a:Bg\u000e{G-Z*feZL7-\u001a\u0006\u0003?\u0001\nqa]3sm&\u001cWM\u0003\u0002\"E\u00051\u0011m]2pI\u0016T!a\t\u0013\u0002\u0013ad'/\u001a7fCN,'BA\u0013'\u0003%AXMY5bY\u0006\u00147OC\u0001(\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014!B:mMRR'\"A\u001b\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u000e\u001a\u0003\u000f1{wmZ5oO\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0012\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011ah\u000f\u0002\u0012)JLwmZ3s%\u0016\u0004xn]5u_JL\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011!(Q\u0005\u0003\u0005n\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"!R$\u000e\u0003\u0019S!a\b\u0012\n\u0005!3%A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0011\u0005\u0015[\u0015B\u0001'G\u000551u\u000e\u001c3feN+'O^5dK\u0006y!/\u001a4fe\u0016t7-Z*pYZ,'\u000f\u0005\u0002P!6\ta$\u0003\u0002R=\ty!+\u001a4fe\u0016t7-Z*pYZ,'/\u0001\tue&<w-\u001a:MS\u001a,7-_2mKB\u0019AK\u0017/\u000e\u0003US!AV,\u0002\t%l\u0007\u000f\u001c\u0006\u0003?aS!!\u0017\u0012\u0002\u0011Q\u0014\u0018nZ4feNL!aW+\u0003!Q\u0013\u0018nZ4fe2Kg-Z2zG2,\u0007CA/a\u001b\u0005q&BA0#\u0003\u0019!w.\\1j]&\u0011\u0011M\u0018\u0002\b)JLwmZ3s\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005\u0015#\u0017BA3G\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u001dQ\u0014\u0018nZ4feN+'O^5dKB\u0011\u0001.[\u0007\u0002/&\u0011!n\u0016\u0002\u000f)JLwmZ3s'\u0016\u0014h/[2f\u0003!)g/\u001a8u\u0005V\u001c\bCA7q\u001b\u0005q'BA8#\u0003\u0019)g/\u001a8ug&\u0011\u0011O\u001c\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0006ukZ<\b0\u001f>|yv\u0004\"a\u0014\u0001\t\u000baR\u0001\u0019A\u001d\t\u000b}R\u0001\u0019\u0001!\t\u000b\rS\u0001\u0019\u0001#\t\u000b%S\u0001\u0019\u0001&\t\u000b5S\u0001\u0019\u0001(\t\u000bIS\u0001\u0019A*\t\u000b\tT\u0001\u0019A2\t\u000b\u0019T\u0001\u0019A4\t\u000b-T\u0001\u0019\u00017)\u0005)y\b\u0003BA\u0001\u0003/i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0005\u0003\u0017\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002\u000e\u0005=\u0011!\u00022fC:\u001c(\u0002BA\t\u0003'\tqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003+\t1a\u001c:h\u0013\u0011\tI\"a\u0001\u0003\u0013\u0005+Ho\\<je\u0016$\u0017a\u00029s_\u000e,7o\u001d\u000b\u0007\u0003?\t)#!\u000e\u0011\u0007=\u000b\t#C\u0002\u0002$y\u0011A\"S7q_J$(+Z:vYRDq!a\n\f\u0001\u0004\tI#A\u0004d_:$X\r\u001f;\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\f!\u0003\u0015)H/\u001b7t\u0013\u0011\t\u0019$!\f\u0003\u001b%k\u0007o\u001c:u\u0007>tG/\u001a=u\u0011\u0019\t9d\u0003a\u00019\u00069AO]5hO\u0016\u0014\u0018A\u00049s_\u000e,7o\u001d+sS\u001e<WM\u001d\u000b\u0007\u0003{\t\u0019%!\u0012\u0011\u0007-\ny$C\u0002\u0002B1\u0012A!\u00168ji\"9\u0011q\u0005\u0007A\u0002\u0005%\u0002BBA\u001c\u0019\u0001\u0007A,\u0001\u0004de\u0016\fG/\u001a\u000b\t\u0003?\tY%!\u0014\u0002P!9\u0011qE\u0007A\u0002\u0005%\u0002BBA\u001c\u001b\u0001\u0007A\fC\u0004\u0002R5\u0001\r!a\u0015\u0002\u0013Q\u0014\u0018nZ4fe&#\u0007\u0003BA+\u0003GrA!a\u0016\u0002`A\u0019\u0011\u0011\f\u0017\u000e\u0005\u0005m#bAA/Q\u00051AH]8pizJ1!!\u0019-\u0003\u0019\u0001&/\u001a3fM&!\u0011QMA4\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\r\u0017\u0002\rU\u0004H-\u0019;f))\ty\"!\u001c\u0002p\u0005M\u0014Q\u000f\u0005\b\u0003Oq\u0001\u0019AA\u0015\u0011\u0019\t\tH\u0004a\u00019\u0006AQ\r_5ti&tw\r\u0003\u0004\u000289\u0001\r\u0001\u0018\u0005\b\u0003or\u0001\u0019AA=\u0003u\u0011X\r\\3bg\u00164u\u000e\u001c3fe>+Ho\u00144TG>\u0004X-\u0012=jgR\u001c\bcA\u0016\u0002|%\u0019\u0011Q\u0010\u0017\u0003\u000f\t{w\u000e\\3b]\u0006Aa/\u00197jI\u0006$X\r\u0006\u0005\u0002\u0004\u0006\r\u0016QUAT!\u0019\t))a$\u0002\u0016:!\u0011qQAF\u001d\u0011\tI&!#\n\u00035J1!!$-\u0003\u001d\u0001\u0018mY6bO\u0016LA!!%\u0002\u0014\n!A*[:u\u0015\r\ti\t\f\t\u0005\u0003/\u000by*\u0004\u0002\u0002\u001a*\u0019\u0011%a'\u000b\u0007\u0005u%%\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eLA!!)\u0002\u001a\n\tb+\u00197jI\u0006$\u0018n\u001c8NKN\u001c\u0018mZ3\t\u000f\u0005\u001dr\u00021\u0001\u0002*!1\u0011qG\bA\u0002qC\u0011\"a\u001e\u0010!\u0003\u0005\r!!\u001f\u0002%Y\fG.\u001b3bi\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003[SC!!\u001f\u00020.\u0012\u0011\u0011\u0017\t\u0005\u0003g\u000bY,\u0004\u0002\u00026*!\u0011qWA]\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00061JA!!0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-Y\fG.\u001b3bi\u0016\u001cFo\u001c:fIR\u0013\u0018nZ4feN$B!!\u0010\u0002D\"9\u0011QY\tA\u0002\u0005\u001d\u0017AD:u_J,G\r\u0016:jO\u001e,'o\u001d\t\u0006\u0003\u000b\u000by\tX\u0001\rM&tG\rV3na2\fG/\u001a\u000b\u0007\u0003\u001b\f\u0019.a6\u0011\u0007u\u000by-C\u0002\u0002Rz\u0013qAU3mK\u0006\u001cX\rC\u0004\u0002VJ\u0001\r!a\u0015\u0002\u0013%$wJ\u001d+ji2,\u0007bBAm%\u0001\u0007\u00111K\u0001\ra\u0006\u0014XM\u001c;G_2$WM]\u0001\u0011M&tG\rV3na2\fG/\u001a\"z\u0013\u0012$b!!4\u0002`\u0006\u0005\bbBAk'\u0001\u0007\u00111\u000b\u0005\b\u00033\u001c\u0002\u0019AA*\u0003M1\u0017N\u001c3UK6\u0004H.\u0019;f\u0005f$\u0016\u000e\u001e7f)\u0019\ti-a:\u0002j\"9\u0011Q\u001b\u000bA\u0002\u0005M\u0003bBAm)\u0001\u0007\u00111K\u0001\u0017e\u0016\u001cx\u000e\u001c<f%\u0016dW-Y:f\r>dG-\u001a:JIR!\u00111KAx\u0011\u001d\t\t0\u0006a\u0001\u0003'\nqB]3mK\u0006\u001cXMR8mI\u0016\u0014\u0018\nZ\u0001\u0011g\u0016$(+\u001a7fCN,gi\u001c7eKJ$B!!\u0010\u0002x\"9\u0011q\u0007\fA\u0002\u0005e\bcA/\u0002|&\u0019\u0011Q 0\u0003\u001dI+G.Z1tKR\u0013\u0018nZ4fe\u0006AR\u000f\u001d3bi\u0016$&/[4hKJ\u001c\bK]8qKJ$\u0018.Z:\u0015\u0011\u0005u\"1\u0001B\u0003\u0005\u000fAa!a\u000e\u0018\u0001\u0004a\u0006bBAm/\u0001\u0007\u00111\u000b\u0005\b\u0005\u00139\u0002\u0019\u0001B\u0006\u0003\u0011Aw.\\3\u0011\u000b-\u0012i!a\u0015\n\u0007\t=AF\u0001\u0004PaRLwN\\\u0001\u000bO\u0016tWM]1uK&#G\u0003BA*\u0005+AqAa\u0006\u0019\u0001\u0004\t\u0019&\u0001\u0005qCJ,g\u000e^%e\u0003A1\u0018\r\\5eCR,gi\u001c7eKJLE\r\u0006\u0003\u0002>\tu\u0001BBA\u001c3\u0001\u0007A,A\bva\u0012\fG/\u001a,be&\f'\r\\3t)\u0011\tiDa\t\t\r\u0005]\"\u00041\u0001]\u00035)g.\u00192mKR\u0013\u0018nZ4feR!\u0011Q\bB\u0015\u0011\u0019\t9d\u0007a\u00019\u000612m\u001c9z\u0013:$XM\u001d8bYB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002>\t=\"\u0011\u0007\u0005\u0007\u0003cb\u0002\u0019\u0001/\t\r\tMB\u00041\u0001]\u00039)\b\u000fZ1uK\u0012$&/[4hKJD3\u0001\u0001B\u001c!\u0011\u0011IDa\u0010\u000e\u0005\tm\"\u0002\u0002B\u001f\u0003\u001f\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011\tEa\u000f\u0003\u000fM+'O^5dK\u0002")
public class TriggerAsCodeService
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final FolderService folderService;
    private final ReferenceSolver referenceSolver;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final CiIdService ciIdService;
    private final TriggerService triggerService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerAsCodeService triggerAsCodeService = this;
        synchronized (triggerAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Trigger trigger) {
        boolean bl;
        ReleaseTrigger releaseTrigger;
        this.logger().debug((Function0 & Serializable)() -> "Processing trigger: " + trigger.toString() + " with metadata " + context.metadata().toString());
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger && (releaseTrigger = (ReleaseTrigger)trigger2).getReleaseFolder() != null && !releaseTrigger.getReleaseFolder().startsWith("./")) {
            Option folderExists = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath(releaseTrigger.getReleaseFolder(), releaseTrigger.getReleaseFolder().split("/").length - 1)).toOption();
            bl = folderExists.isDefined();
        } else {
            bl = true;
        }
        boolean releaseFolderOutOfScopeExists = bl;
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        List storedTriggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(parentFolder, false, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).asScala().toList();
        this.validateStoredTriggers((List<Trigger>)storedTriggers);
        this.processTrigger(context, trigger);
        Option option = storedTriggers.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$process$4(trigger, x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Trigger existing = (Trigger)some.value();
            this.logger().debug((Function0 & Serializable)() -> "Updating trigger: " + existing.toString());
            return this.update(context, existing, trigger, releaseFolderOutOfScopeExists);
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Creating trigger: " + trigger.toString());
            return this.create(context, trigger, this.generateId(parentFolder));
        }
        throw new MatchError((Object)option);
    }

    private void processTrigger(ImportContext context, Trigger trigger) {
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        Option home = context.metadata().get((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString());
        this.referenceSolver.resolveReferences((ConfigurationItem)trigger, context.references(), parentFolder);
        this.updateTriggersProperties(trigger, parentFolder, (Option<String>)home);
        this.validateFolderId(trigger);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
    }

    private ImportResult create(ImportContext context, Trigger trigger, String triggerId) {
        trigger.setId(triggerId);
        Trigger created = this.triggerRepository.create(trigger);
        List<ValidationMessage> messages = this.validate(context, trigger, this.validate$default$3());
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<PostCommitAction>)new .colon.colon(() -> this.enableTrigger(created), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TriggerCreatedFromAsCodeEvent(created, context.scmData())), (List)Nil$.MODULE$)), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private ImportResult update(ImportContext context, Trigger existing, Trigger trigger, boolean releaseFolderOutOfScopeExists) {
        trigger.setId(existing.getId());
        trigger.setCiUid(existing.getCiUid());
        this.copyInternalProperties(existing, trigger);
        List<ValidationMessage> messages = this.validate(context, trigger, releaseFolderOutOfScopeExists);
        Trigger updated = this.triggerRepository.update(trigger);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<PostCommitAction>)new .colon.colon(() -> $this.triggerService.refreshTrigger(updated), (List)new .colon.colon(() -> this.enableTrigger(updated), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedFromAsCodeEvent(updated, context.scmData())), (List)Nil$.MODULE$))), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private List<ValidationMessage> validate(ImportContext context, Trigger trigger, boolean releaseFolderOutOfScopeExists) {
        Option<ImportValidator> option = context.validator();
        if (option instanceof Some) {
            Some some = (Some)option;
            ImportValidator validator = (ImportValidator)some.value();
            return validator.validateCi((ConfigurationItem)trigger, context.getFolderInfo(), releaseFolderOutOfScopeExists).toList();
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError(option);
    }

    private boolean validate$default$3() {
        return true;
    }

    private void validateStoredTriggers(List<Trigger> storedTriggers) {
        ((IterableOnceOps)storedTriggers.groupBy((Function1 & Serializable)x$2 -> x$2.getTitle()).values().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$validateStoredTriggers$2(x$3)))).foreach((Function1 & Serializable)triggerGroup -> {
            Trigger trigger = (Trigger)triggerGroup.head();
            throw new AsCodeException("More than one trigger with the name [" + trigger.getTitle() + "] is present in the repository. Don't know which one to update", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    public Release com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(String idOrTitle, String parentFolder) {
        if (Ids.isReleaseId((String)idOrTitle)) {
            return this.findTemplateById(idOrTitle, parentFolder);
        }
        return this.findTemplateByTitle(idOrTitle, parentFolder);
    }

    private Release findTemplateById(String idOrTitle, String parentFolder) {
        Release release;
        try {
            release = this.releaseService.findById(idOrTitle);
        }
        catch (LogFriendlyNotFoundException nfe) {
            release = this.findTemplateByTitle(idOrTitle, parentFolder);
        }
        catch (Exception e) {
            throw new AsCodeException("Failed to find template [" + idOrTitle + "], error [" + e.getMessage() + "].", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return release;
    }

    private Release findTemplateByTitle(String idOrTitle, String parentFolder) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle(parentFolder, idOrTitle, 0, 2, 1)).asScala().toList();
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            Release template = (Release)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return template;
            }
        }
        if (bl) {
            throw new AsCodeException("More than one template with name [" + idOrTitle + "] is present in the folder [" + parentFolder + "]. Please use an unique name.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (Nil$.MODULE$.equals(list)) {
            throw new AsCodeException("There is no template with name [" + idOrTitle + "] under folder [" + parentFolder + "]", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)list);
    }

    public String com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(String releaseFolderId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(releaseFolderId), "/"), $this.folderService.findByPath$default$2()).getId());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String resolvedReleaseFolderID = (String)success.value();
            return resolvedReleaseFolderID;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw new AsCodeException("Unable to resolve release folder id, " + releaseFolderId + " for trigger: failure message " + ex.getMessage(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)try_);
    }

    private void setReleaseFolder(ReleaseTrigger trigger) {
        ObjectRef folderId = ObjectRef.create((Object)trigger.getReleaseFolder());
        if ((String)folderId.elem != null) {
            String string;
            Option option;
            if (((String)folderId.elem).startsWith("./")) {
                String rootFolderPath = ((IterableOnceOps)this.folderService.getPath(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])trigger.getFolderId().split("/")), 2)).mkString("/")).drop(1)).mkString("/");
                folderId.elem = trigger.getReleaseFolder().replace("./", rootFolderPath + "/");
            }
            if ((option = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath((String)folderId$1.elem, ((String)folderId$1.elem).split("/").length - 1)).toOption()) instanceof Some) {
                Some some = (Some)option;
                Folder folder = (Folder)some.value();
                string = folder.getId();
            } else if (None$.MODULE$.equals(option)) {
                string = null;
            } else {
                throw new MatchError((Object)option);
            }
            String releaseFolder = string;
            trigger.setReleaseFolder(releaseFolder);
            return;
        }
    }

    private void updateTriggersProperties(Trigger trigger, String parentFolder, Option<String> home) {
        trigger.setFolderId(parentFolder);
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            releaseTrigger.setTemplate(this.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(releaseTrigger.getTemplate(), parentFolder).getId());
            this.setReleaseFolder(releaseTrigger);
            return;
        }
        if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$1(p))).collect((PartialFunction)new Serializable(this, parentFolder){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final String parentFolder$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(stringValue.value(), this.parentFolder$1);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(MappedProperty x1) {
                    MappedProperty mappedProperty = x1;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parentFolder$1 = parentFolder$1;
                }
            }).map((Function1 & Serializable)templateId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$3(eventBasedTrigger, templateId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "template";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$5(p))).collect((PartialFunction)new Serializable(this, home){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final Option home$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(FolderAsCodeService$.MODULE$.absolutePath(stringValue.value(), (Option<String>)this.home$1));
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(MappedProperty x2) {
                    MappedProperty mappedProperty = x2;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.home$1 = home$1;
                }
            }).map((Function1 & Serializable)folderId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$7(eventBasedTrigger, folderId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "releaseFolder";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            return;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private String generateId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Trigger.class), parentId);
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            throw new AsCodeException("Failed to create trigger " + trigger.getTitle() + ", you cannot create trigger on the root folder. The root folder path is not supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            java.util.List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$4 -> !x$4.isPassword())).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$3(x$5)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$4(x$6)))).toList()).asJava());
            return;
        }
    }

    private void enableTrigger(Trigger trigger) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, false);
            return;
        }
        this.triggerLifecycle.disable(trigger);
    }

    private void copyInternalProperties(Trigger existing, Trigger updatedTrigger) {
        CollectionConverters$.MODULE$.ListHasAsScala(updatedTrigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
            updatedTrigger.setProperty(internalProperty, existing.getProperty(internalProperty));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$process$4(Trigger trigger$1, Trigger x$1) {
        String string = x$1.getTitle();
        String string2 = trigger$1.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateStoredTriggers$2(List x$3) {
        return x$3.length() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$1(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "template";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$3(EventBasedTrigger x3$1, Release templateId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("templateId");
        value.setValue(templateId.getId());
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$5(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "releaseFolder";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$7(EventBasedTrigger x3$1, String folderId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("releaseFolderId");
        value.setValue(folderId);
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$2, Variable v) {
        return x2$2.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$5) {
        return x$5._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$6) {
        return x$6.getId() != null;
    }

    @Autowired
    public TriggerAsCodeService(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, FolderService folderService, ReferenceSolver referenceSolver, TriggerLifecycle<Trigger> triggerLifecycle, CiIdService ciIdService, TriggerService triggerService, XLReleaseEventBus eventBus) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.referenceSolver = referenceSolver;
        this.triggerLifecycle = triggerLifecycle;
        this.ciIdService = ciIdService;
        this.triggerService = triggerService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

