package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import grizzled.slf4j.Logging

case class StringReferenceCreationConfig(
                                          ci: ConfigurationItem,
                                          folderPath: String = "",
                                          home: Option[String] = None,
                                          templateIds: Map[String, String] = Map.empty // TODO: templateIds should be a more generic cache lookup mechanism but the map is ok for the time being
                                        )

case class StringReferenceContainer(
                                     ci: ConfigurationItem,
                                     values: Map[PropertyDescriptor, Option[AnyRef]]
                                   )

trait StringReferenceCreationHandler extends PartialFunction[StringReferenceCreationConfig, StringReferenceContainer] with Logging
