package com.xebialabs.xlrelease.ascode.yaml.writer

import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.utils.TypeSugar.typeOf
import com.xebialabs.ascode.yaml.sugar.{SugarConfig, Sugarizer}
import com.xebialabs.ascode.yaml.writer.support.JacksonCiWriter
import com.xebialabs.deployit.plugin.api.reflect.Type

class XlrJacksonCiWriter(yamlGenerator: YAMLGenerator)(implicit sugarConfig: SugarConfig) extends JacksonCiWriter(yamlGenerator)(sugarConfig) {
  private def writeWithSugar(field: String, value: String)(implicit ciType: Type): Unit = {
    Sugarizer.writeWithSugar(field, value).foreach { case (k, v) => yamlGenerator.writeStringField(k, v) }
  }

  override def startCi(`type`: String, id: String): Unit = {
    yamlGenerator.writeStartObject()

    implicit val ciType: Type = typeOf(`type`)
    if (id != null) {
      writeWithSugar("name", id)
    }
    writeWithSugar("type", `type`)
  }
}
