package com.xebialabs.xlrelease.ascode.service.spec

import com.xebialabs.ascode.service.spec.SpecInterpreter._
import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.xlrelease.api.v1.ApplicationApi
import com.xebialabs.xlrelease.ascode.service.spec.XLREntityKinds.APPLICATION
import com.xebialabs.xlrelease.ascode.yaml.model.{Application, ApplicationsSpec}
import com.xebialabs.xlrelease.builder.ApplicationBuilder
import com.xebialabs.xlrelease.domain.environments.{Application => ApiApplication}
import com.xebialabs.xlrelease.environments.repository.{ApplicationRepository, EnvironmentRepository}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class ApplicationsSpecInterpreter(applicationApi: ApplicationApi,
                                  applicationRepository: ApplicationRepository,
                                  environmentRepository: EnvironmentRepository) extends SpecInterpreter {
  override def isDefinedAt(config: InterpreterContext): Boolean = config.definition.spec.isInstanceOf[ApplicationsSpec]

  override def apply(config: InterpreterContext): AsCodeResponse = {
    val spec = config.definition.spec.asInstanceOf[ApplicationsSpec]
    val changedIds = createOrUpdate[Application, ApiApplication](
      entities = spec.applications,
      defaultIds = APPLICATION.ids,
      extractLabel = application => application.getTitle,
      prepare = application => {
        ApplicationBuilder.newApplication
          .withTitle(application.name)
          .withEnvironments(application.environments.map(environmentRepository.findEnvironmentByTitle).asJava)
          .build
      },
      create = applicationApi.create,
      update = apiApplication => {
        val loadedApplication = applicationRepository.findApplicationByTitle(apiApplication.getTitle)
        apiApplication.setId(loadedApplication.getId)
        applicationApi.update(apiApplication)
        apiApplication
      }
    )
    AsCodeResponse.ids(changedIds)
  }
}
