package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.domain.variables.ReferenceVariable
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.variable.VariableHelper
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.Try

@Component
@Autowired
class ReferenceVariableGeneratorHandler(configurationRepository: ConfigurationRepository) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[ReferenceVariable]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val variable = ciWithHome.ci.asInstanceOf[ReferenceVariable]
    Try {
      Option(variable.getValue).filterNot(VariableHelper.containsVariables).
        map(configurationId => configurationRepository.findConfigurationTitleById(configurationId))
    }.recover { case _: Exception => Some(null) }.toOption.flatten.foreach(variable.setValue)
  }
}
