package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.ascode.utils.TypeSugar.typeOf
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.service.SharedConfigurationService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class CollectionConfigurationCiReferenceCreationHandler @Autowired()(
                                                                          sharedConfigurationService: SharedConfigurationService
                                                                        ) extends CiReferenceCreationHandler {
  override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean =
    Option(helper.propertyDescriptor.getReferencedType).exists(_.isSubTypeOf(typeOf[Configuration])) &&
      (helper.reference.getProperty.getKind.equals(PropertyKind.SET_OF_CI) || helper.reference.getProperty.getKind.equals(PropertyKind.LIST_OF_CI))

  override def apply(config: CiReferenceCreationConfig): Option[AnyRef] = {
    val cis = config.reference.getIds.asScala.flatMap { referencedName =>
      sharedConfigurationService.searchByTypeAndTitle(config.propertyDescriptor.getReferencedType, referencedName, config.folderPath, false).asScala
        .sortBy(ci => Option(ci.getFolderId).getOrElse(""))(Ordering.String.reverse)
        .headOption
    }

    config.reference.getProperty.getKind match {
      case PropertyKind.SET_OF_CI => Some(cis.toSet.asJava)
      case PropertyKind.LIST_OF_CI => Some(cis.asJava)
      case _ => None
    }
  }
}
