package com.xebialabs.xlrelease.versioning.ascode.scm

import com.xebialabs.xlrelease.ascode.yaml.model.ImportsSpec
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings.FOLDER_VERSIONING_YAML_FILENAME
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.nio.charset.StandardCharsets
import scala.util.Try

@Component
class ImportCrawler @Autowired()(definitionParser: XLRDefinitionParser) {
  def findAllImports(scmPath: String)(implicit scm: AsCodeJGitConnector, version: String): Seq[String] = {
    val releasefiles = scm.checkoutByPathAndFilenameRecursive(scmPath, FOLDER_VERSIONING_YAML_FILENAME, version)
    val releasefilesPaths = releasefiles.filesToAdd.map(_.absolutePath)

    val importsPaths = releasefiles.filesToAdd.flatMap(file => {
      val fileContent = new String(file.getContent(), StandardCharsets.UTF_8)
      val imports = getImportsOf(fileContent)
      imports.map(i => s"${file.absolutePath.stripSuffix(FOLDER_VERSIONING_YAML_FILENAME)}$i")
    })

    (importsPaths ++ releasefilesPaths).map(_.stripPrefix(s"$scmPath/")).sorted
  }

  private def getImportsOf(yaml: String): Seq[String] = {
    val specs = YamlUtils.preprocessYaml(yaml)
    val importDefs = specs.map(s => Try(definitionParser.parse(s)))
      .filter(parseAttempt => parseAttempt.isSuccess && parseAttempt.get.spec.isInstanceOf[ImportsSpec])
      .map(_.get)
    importDefs.flatMap(_.spec.asInstanceOf[ImportsSpec].imports)
  }

}
