package com.xebialabs.xlrelease.versioning.ascode.scm.connector

import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.service.ConfigurationVariableService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class AsCodeJGitConnectorInitializer @Autowired()(configurationVariableService: ConfigurationVariableService){

  def init(config: FolderVersioningSettings): AsCodeJGitConnector = {
    val connectorConfig = config.gitConnection
    configurationVariableService.resolve(connectorConfig)

    new AsCodeJGitConnector(config)
  }
}
