package com.xebialabs.xlrelease.versioning.ascode.scm

import com.xebialabs.overthere.OverthereFile
import com.xebialabs.overthere.util.ByteArrayFile
import com.xebialabs.xlrelease.ascode.service.FileResolver
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector

class ScmFileResolver(scmConnector: AsCodeJGitConnector,
                      settings: FolderVersioningSettings,
                      version: String)
  extends FileResolver {


  private def getEntityFromScm(locationRef: String): Option[OverthereFile] = {
    val scmPath = settings.scmPath
    val normalizedLocationRef = FolderVersioningSettings.getDefinitionsPath(scmPath, locationRef)
    val blobs = scmConnector.checkout(Array(normalizedLocationRef), version)
    val binaryFile = blobs.filesToAdd.head
    val content = binaryFile.getContent()
    Some(new ByteArrayFile(locationRef, content))
  }

  override def resolve(ref: String): Option[OverthereFile] = {
    getEntityFromScm(ref)
  }

  override def close(): Unit = {
    // nothing
  }
}

