package com.xebialabs.xlrelease.ascode.service.validator

import com.xebialabs.ascode.yaml.model.Definition

object SpecValidator {
  def compose(specValidators: Iterable[SpecValidator]): PartialFunction[Definition, Unit] = {
    specValidators
      .reduceLeft[PartialFunction[Definition, Unit]]((left, right) => left.orElse(right))
      .orElse(new PartialFunction[Definition, Unit] {
        override def isDefinedAt(x: Definition): Boolean = true
        override def apply(v1: Definition): Unit = {}
      })
  }
}

trait SpecValidator extends PartialFunction[Definition, Unit]