package com.xebialabs.xlrelease.ascode.service.validator

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.{Definition, RolesSpec}
import org.springframework.stereotype.Component

@Component
class RolesSpecValidator extends SpecValidator {
  override def isDefinedAt(definition: Definition): Boolean = definition.spec.isInstanceOf[RolesSpec]

  override def apply(definition: Definition): Unit = {
    val rolesSpec = definition.spec.asInstanceOf[RolesSpec]
    rolesSpec.roles.foreach { role =>
      if (role.name == null || role.name.isEmpty) {
        throw new AsCodeException(s"The current definition is not valid. Some of the names are empty. All the roles must have a name.")
      }
    }
  }
}
