package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.domain.CreateReleaseTask
import com.xebialabs.xlrelease.repository.FolderRepository
import com.xebialabs.xlrelease.service.ReleaseService
import com.xebialabs.xlrelease.variable.VariableHelper
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters.CollectionHasAsScala
import scala.util.Try

@Component
class CreateReleaseTaskGeneratorHandler @Autowired()(
                                                      folderRepository: FolderRepository,
                                                      releaseService: ReleaseService,
                                                      folderAsCodeService: FolderAsCodeService
                                                    ) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[CreateReleaseTask]


  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val createReleaseTask = ci.asInstanceOf[CreateReleaseTask]

    Try {
      Option(createReleaseTask.getFolderId)
        .filterNot(VariableHelper.containsVariables)
        .map(folderId => FolderFilterGeneratorHandler.referencePath(Utils.joinPaths(folderRepository.getPath(folderId).tail), ciWithHome.home))
    }.recover {
      case _: Exception => Some(null)
    }.toOption.flatten.foreach(createReleaseTask.setFolderId)

    Try {
      Option(createReleaseTask.getTemplateId)
        .filterNot(VariableHelper.containsVariables)
        .map { templateId =>
          val templateTitle = releaseService.getTitle(templateId)
          FolderFilterGeneratorHandler.referencePath(folderAsCodeService.generateAbsolutePath(templateId, templateTitle), ciWithHome.home)
        }
    }.recover {
      case _: IllegalArgumentException => Some(releaseService.getTitle(createReleaseTask.getTemplateId))
    }.toOption.flatten.foreach(createReleaseTask.setTemplateId)

    createReleaseTask.getTemplateVariables.asScala.foreach(_.setValueProvider(null))
  }
}
