package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.DeliveryTaskStringReferenceCreationHandler.deliveryTaskType
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.dsl.resolver.{DeliveryTaskPathResolver, DeliveryTaskToPathResolver}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters.{CollectionHasAsScala, MapHasAsScala}

@Component
class CustomScriptTaskGeneratorHandler(deliveryTaskToPathResolver: DeliveryTaskToPathResolver) extends CiReferenceGeneratorHandler {

  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[CustomScriptTask]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val customScriptTask = ciWithHome.ci.asInstanceOf[CustomScriptTask]
    val pythonScript = customScriptTask.getPythonScript
    val pythonPrefix = "pythonScript."
    // Set Empty Synthetic output properties values to null
    pythonScript.getOutputProperties.asScala.filter(pd => pd.get(pythonScript) == "").foreach(pd => pd.set(pythonScript, null))

    //Set value to null for input properties that have a corresponding variable mapping
    val variableMappings = customScriptTask.getVariableMapping.asScala.view.filterKeys(_.startsWith(pythonPrefix)).map {
      case (k, v) => k.stripPrefix(pythonPrefix) -> v
    }.toMap
    pythonScript.getInputProperties.asScala.filter(pd => variableMappings.contains(pd.getName)).foreach(_.set(pythonScript, null))

    // Path resolution for DeliveryTask
    if (customScriptTask.getTaskType.isSubTypeOf(Type.valueOf(deliveryTaskType))) {
      deliveryTaskToPathResolver.resolve(pythonScript).foreach { case (property, change) =>
        if (DeliveryTaskPathResolver.fieldsWithFolderPath.exists(_.equals(property.getName))) property.set(pythonScript, FolderFilterGeneratorHandler.referencePath((change.newValue.getOrElse(change.oldValue)), ciWithHome.home))
        else property.set(pythonScript, change.newValue.getOrElse(change.oldValue))
      }
    }
  }
}
