package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class StringReferenceCreationService @Autowired()(generators: java.util.List[StringReferenceCreationHandler]) extends Logging {
  private val handlerFunction = generators.asScala
    .reduceLeft[PartialFunction[StringReferenceCreationConfig, StringReferenceContainer]] { case (left, right) =>
      left.orElse(right)
    }.orElse(
    new StringReferenceCreationHandler {
      override def isDefinedAt(helper: StringReferenceCreationConfig): Boolean = true

      override def apply(helper: StringReferenceCreationConfig): StringReferenceContainer = StringReferenceContainer(helper.ci, Map.empty)
    }
  )

  def createStringReference(config: StringReferenceCreationConfig): Unit = {
    val reference = handlerFunction(config)

    reference.values.foreach {
      case (descriptor, possibleValue) =>
        val value = possibleValue.orNull

        logger.debug(s"Setting reference property ${config.ci} to $value")
        descriptor.set(reference.ci, value)
    }
  }
}
