package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.api.v1.EnvironmentApi
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class EnvironmentFilterGeneratorHandler(
                                         environmentApi: EnvironmentApi
                                       ) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[EnvironmentFilter]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val filter = ci.asInstanceOf[EnvironmentFilter]

    if (filter.getEnvironmentId != null) {
      val env = environmentApi.getById(filter.getEnvironmentId)

      filter.setEnvironmentId(env.getTitle)
    }
  }
}
