package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.repository.FolderRepository
import com.xebialabs.xlrelease.variable.VariableHelper
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class GateTaskGeneratorHandler @Autowired()(
                                             folderRepository: FolderRepository
                                           ) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[GateTask]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val gateTask = ci.asInstanceOf[GateTask]
    // Only preserve dependencies using variables because references to live releases don't make sense here
    val dependencies = gateTask.getDependencies.asScala
      .filter(dependency => VariableHelper.containsVariables(dependency.getTargetId))
      .map(dependency => {
        dependency.setTarget(null)
        dependency
      })
    gateTask.setDependencies(dependencies.asJava)
  }
}
