package com.xebialabs.xlrelease.versioning.scheduler

import com.xebialabs.xlrelease.service.{ConfigurationService, FolderService}
import com.xebialabs.xlrelease.versioning.ascode.scm.{FolderVersionApplyHelper, FolderVersioningService}
import com.xebialabs.xlrelease.versioning.scheduler.FolderVersioningAutoApplyJobService.AUTO_APPLY_JOB_DATA_KEY
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

@DisallowConcurrentExecution
class FolderVersioningAutoApplyQuartzJob extends Job with FolderVersionApplyHelper with Logging {

  private val TYPE_GITOPS_SETTINGS = "xlrelease.GitOpsVersionControlFeature"

  private val AUTO_VERSION_APPLY_ENABLED = "autoApplyScmVersion"

  @Autowired
  var configurationService: ConfigurationService = _

  @Autowired
  var folderService: FolderService = _

  @Autowired
  var folderVersioningService: FolderVersioningService = _

  override def execute(context: JobExecutionContext): Unit = {
    val jobKey = context.getJobDetail.getKey
    Try {
      if (isAutoVersionApplyEnabled()) {
        val jobDataMap = context.getJobDetail.getJobDataMap
        val folderId = jobDataMap.getString(AUTO_APPLY_JOB_DATA_KEY)
        val folderName = folderService.getTitle(folderId)
        fetchAndApplyLatestVersion(folderId, folderName)
      } else {
        logger.debug(s"Automatic version apply is disabled. Not doing anything for quartz job with key [$jobKey].")
      }
    } match {
      case Failure(ex) => logger.error(s"Unable to start quartz job with key [$jobKey]", ex)
      case Success(_) => logger.debug(s"Executed quartz job to auto apply folder version with key [$jobKey]")
    }

  }

  private def isAutoVersionApplyEnabled(): Boolean = {
    configurationService.getFeatureSettings(TYPE_GITOPS_SETTINGS).getProperty(AUTO_VERSION_APPLY_ENABLED)
  }
}
