package com.xebialabs.xlrelease.ascode.yaml.writer

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.ascode.yaml.writer.{GenerateContext, SpecWriter}
import com.xebialabs.xlrelease.ascode.yaml.model.ApplicationsSpec

object ApplicationsWriter extends SpecWriter {

  override def write(spec: Spec, yamlGenerator: YAMLGenerator)(implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext = {
    val appSpec = spec.asInstanceOf[ApplicationsSpec]
    mapper.writeValue(yamlGenerator, appSpec.applications)
    GenerateContext(Nil, Map.empty)
  }
}
