package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.schema.JsonSchema._
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._
import com.xebialabs.xlrelease.ascode.Version.XLR_API_VERSION
import com.xebialabs.xlrelease.ascode.yaml.model.StartReleaseSpec

object StartReleaseParser extends SpecParser with SchemaGenerator {
  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    val releaseName = node.requiredString("name")
    val templatePath = node.requiredString("template")
    val variables = node.mapStringAnyRef("variables")
    val autoStart = node.property("autoStart").forall(_.asBoolean(true))
    val riskProfile = node.string("riskProfile")

    StartReleaseSpec(releaseName, templatePath, riskProfile, variables, autoStart)
  }

  override def generateSchema(definitionKind: String)(implicit generatorContext: SchemaGeneratorContext): SchemaNode = {
    node
      .additionalProperties(false)
      .required("apiVersion", "kind", "spec")
      .properties(
        version(XLR_API_VERSION),
        kind(definitionKind),
        metadata(node
          .`type`("object")),
        spec(node
          .`type`("object")
          .additionalProperties(false)
          .required("name", "template")
          .properties(
            "name" -> node
              .`type`("string")
              .description("Name of the release that will be created"),
            "template" -> node
              .`type`("string")
              .description("Name of the template to use for this release"),
            "autoStart" -> node
              .`type`("boolean")
              .description("Setting this to true will cause the release to automatically start on creation"),
            "variables" -> node
              .`type`("object")
              .description("Object containing variables")
          ))
      )
  }
}
