package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.ManagedApplicationsTasksStringReferenceCreationHandler._
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.service.ReleaseService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

private object ManagedApplicationsTasksStringReferenceCreationHandler {
  val deleteWorkflowIdField = "deleteWorkflowId"
  val updateWorkflowIdField = "updateWorkflowId"
  val createApplicationIdType = "managedApplications.CreateApplication"
  val updateApplicationIdType = "managedApplications.UpdateApplication"

  def deleteWorkflowIdFieldInCreateApplicationDescriptor(): PropertyDescriptor =
    typeOf(createApplicationIdType).getDescriptor.getPropertyDescriptor(deleteWorkflowIdField)

  private def deleteWorkflowIdFieldInUpdateApplicationDescriptor(): PropertyDescriptor =
    typeOf(updateApplicationIdType).getDescriptor.getPropertyDescriptor(deleteWorkflowIdField)

  private def updateWorkflowIdInCreateApplicationDescriptor(): PropertyDescriptor =
    typeOf(createApplicationIdType).getDescriptor.getPropertyDescriptor(updateWorkflowIdField)

  private def updateWorkflowIdInUpdateApplicationDescriptor(): PropertyDescriptor =
    typeOf(updateApplicationIdType).getDescriptor.getPropertyDescriptor(updateWorkflowIdField)
}

@Component
class ManagedApplicationsTasksStringReferenceCreationHandler @Autowired()(releaseService: ReleaseService, folderAsCodeService: FolderAsCodeService)
  extends StringReferenceCreationHandler {

  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = {
    config.ci.isInstanceOf[CustomScriptTask] && (deleteWorkflowIdFieldInCreateApplicationDescriptor().get(config.ci.getProperty("pythonScript")) != null
      || deleteWorkflowIdFieldInUpdateApplicationDescriptor().get(config.ci.getProperty("pythonScript")) != null
      || updateWorkflowIdInCreateApplicationDescriptor().get(config.ci.getProperty("pythonScript")) != null
      || updateWorkflowIdInUpdateApplicationDescriptor().get(config.ci.getProperty("pythonScript")) != null)
  }

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val createApplicationDeleteWorkflowId = TemplateStringReferenceCreationUtil.mapWorkflowIdToProp(
      config, deleteWorkflowIdFieldInCreateApplicationDescriptor(),
      deleteWorkflowIdFieldInCreateApplicationDescriptor().get(config.ci.getProperty("pythonScript")), folderAsCodeService, releaseService)
    val updateApplicationDeleteWorkflowId = TemplateStringReferenceCreationUtil.mapWorkflowIdToProp(
      config, deleteWorkflowIdFieldInUpdateApplicationDescriptor(),
      deleteWorkflowIdFieldInUpdateApplicationDescriptor().get(config.ci.getProperty("pythonScript")), folderAsCodeService, releaseService)
    val createApplicationUpdateWorkflowId = TemplateStringReferenceCreationUtil.mapWorkflowIdToProp(
      config, updateWorkflowIdInCreateApplicationDescriptor(),
      updateWorkflowIdInCreateApplicationDescriptor().get(config.ci.getProperty("pythonScript")), folderAsCodeService, releaseService)
    val updateApplicationUpdateWorkflowId = TemplateStringReferenceCreationUtil.mapWorkflowIdToProp(
      config, updateWorkflowIdInUpdateApplicationDescriptor(),
      updateWorkflowIdInUpdateApplicationDescriptor().get(config.ci.getProperty("pythonScript")), folderAsCodeService, releaseService)

    StringReferenceContainer(config.ci.getProperty("pythonScript"),
      (createApplicationDeleteWorkflowId ++ updateApplicationDeleteWorkflowId ++ createApplicationUpdateWorkflowId ++ updateApplicationUpdateWorkflowId).toMap)
  }
}
