package com.xebialabs.xlrelease.ascode.rest.support

import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.io.InputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.Consumes
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyReader, Provider}

@Component
@Provider
@Consumes(Array("text/vnd.yaml"))
@Autowired
class DefinitionMessageBodyReaderWriter(parser: XLRDefinitionParser) extends MessageBodyReader[Definition] {
  override def isReadable(`type`: Class[_],
                          genericType: Type,
                          annotations: Array[Annotation],
                          mediaType: MediaType): Boolean = classOf[Definition].isAssignableFrom(`type`)

  override def readFrom(`type`: Class[Definition],
                        genericType: Type,
                        annotations: Array[Annotation],
                        mediaType: MediaType,
                        httpHeaders: MultivaluedMap[String, String],
                        entityStream: InputStream): Definition = parser.parse(entityStream)
}
