package com.xebialabs.xlrelease.versioning.ascode.upgrader

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.builder.FolderBuilder.newFolder
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.sql.snapshots.service.PermissionsSnapshotService
import com.xebialabs.xlrelease.service.{FolderService, SharedConfigurationService}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.versioning.ascode.scm.{FolderVersionApplyHelper, FolderVersioningService}
import com.xebialabs.xlrelease.versioning.ascode.upgrader.BaseContentFolderInitializer._
import com.xebialabs.xlrelease.versioning.scheduler.FolderVersioningAutoApplyJobService
import grizzled.slf4j.Logging

import scala.util.{Failure, Success, Try}

class XLRelease241TemplateContentFolderInitializer(folderService: FolderService,
                                                   folderVersioningService: FolderVersioningService,
                                                   folderVersioningAutoApplyJobService: FolderVersioningAutoApplyJobService,
                                                   sharedConfigurationService: SharedConfigurationService,
                                                   permissionSnapshotService: PermissionsSnapshotService,
                                                   xlrConfig: XlrConfig)
  extends BaseContentFolderInitializer(folderService, folderVersioningService, folderVersioningAutoApplyJobService, sharedConfigurationService, xlrConfig)
    with FolderVersionApplyHelper with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.1.0#6")

  override def doUpgrade(): Boolean = {
    logger.info("Creating default content folder for templates")

    if (xlrConfig.features.provision.folders.enabled) {
      val templatesToCreate = newFolder.withTitle(TEMPLATES_FOLDER_NAME).build
      Try {
        val daiFolder = folderService.findById(DEFAULT_CONTENT_FOLDER_ID, depth = 0)
        val templatesFolder = folderService.create(daiFolder.getId, templatesToCreate, createDefaultTeams = false)

        // get git configuration for root folder
        val gitConfiguration = getGitConfiguration(daiFolder.getId)

        // create folder versioning settings on workflows folder
        createFolderVersioningSettings(templatesFolder.getId,
          gitConfiguration,
          xlrConfig.features.provision.folders.defaultContentFolder.templateFolder.scmBranch,
          xlrConfig.features.provision.folders.defaultContentFolder.templateFolder.scmPath,
          autoImport = false)

        applyLatestContent(templatesFolder.getId, templatesFolder.getTitle)

        // Event listeners are not subscribed yet, we need to do snapshot manually
        permissionSnapshotService.makeSnapshot(Option(templatesFolder.getId))
      } match {
        case Failure(exception) => logger.error("Failure while creating and importing content for the default content folder for templates", exception)
        case Success(_) => logger.debug(s"Finished creation of default content folder for templates")
      }
    } else {
      logger.info(s"Skipped default content folder for templates creation as folder provisioning is disabled")
    }
    true
  }

}
