package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel
import com.xebialabs.xlrelease.environments.service.EnvironmentLabelService
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentLabelFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.Try
import scala.util.Success
import scala.util.Failure

@Component
@Autowired
class EnvironmentLabelFilterStringReferenceCreationHandler(environmentLabelService: EnvironmentLabelService) extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[EnvironmentLabelFilter]

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val filter = config.ci.asInstanceOf[EnvironmentLabelFilter]
    val labelName = filter.getEnvironmentLabelId
    val descriptor = filter.getType.getDescriptor.getPropertyDescriptor("environmentLabelId")

    val environmentLabel: EnvironmentLabel = Try(environmentLabelService.findByTitle(labelName)) match {
      case Success(env) => env
      case Failure(_) => throw new AsCodeException(s"Label with name $labelName was not found. Please create it first before using it.")
    }
    config.ci.setId("-1")
    StringReferenceContainer(config.ci, Map(descriptor -> Some(Ids.getName(environmentLabel.getId))))
  }
}
