package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.service.ReleaseService
import com.xebialabs.xlrelease.udm.reporting.filters.impl.TemplateFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class TemplateFilterGeneratorHandler @Autowired()(
                                                   releaseService: ReleaseService,
                                                   folderAsCodeService: FolderAsCodeService
                                                 ) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[TemplateFilter]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val templateFilter = ci.asInstanceOf[TemplateFilter]
    Option(templateFilter.getTemplateId).map { templateId =>
      try {
        val template = releaseService.findById(templateId)
        FolderFilterGeneratorHandler.referencePath(folderAsCodeService.generateAbsolutePath(template.getId, template.getTitle), ciWithHome.home)
      } catch {
        case _ => throw new AsCodeException(s"TemplateFilter with Template id [${templateId}] was not found")
      }
    }.foreach(templateFilter.setTemplateId)
  }
}
