package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.api.internal.CalendarResource
import com.xebialabs.xlrelease.ascode.yaml.model.{CalendarAsCode, ReleaseCalendar}
import com.xebialabs.xlrelease.domain.folder.Folder
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Collections.singletonList
import java.util.Date
import scala.collection.immutable.ListMap
import scala.collection.mutable.ListBuffer

@Component
class CalendarAsCodeGenerator @Autowired()(calendarResource: CalendarResource)
  extends GenerateStrategy[CalendarAsCode] {
  /**
   * This order will be used to sort generate strategies
   */
  override val generateOrder: Double = 60

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateCalendar
  }

  override protected def generateGlobal(config: CiGenerateConfig): Map[Option[Folder], List[CalendarAsCode]] = {
    val configs = ListBuffer.empty[CalendarAsCode]

    val now = new Date
    val blackouts = calendarResource.getBlackouts(now, null)
    val specialDays = calendarResource.getSpecialDays(now, null)

    if (!blackouts.isEmpty || !specialDays.isEmpty) {
      val calendar = new ReleaseCalendar
      calendar.setBlackouts(blackouts)
      calendar.setSpecialDays(specialDays)

      val calendarCi = new CalendarAsCode
      calendarCi.setCalendar(singletonList(calendar))

      configs += calendarCi
    }

    ListMap(None -> configs.toList)
  }

  override protected def filter(results: Map[Option[Folder], List[CalendarAsCode]], ciTitle: String): Map[Option[Folder], List[CalendarAsCode]] = {
    results
  }
}
