package com.xebialabs.xlrelease.builder

import com.xebialabs.xlrelease.domain.GlobalExportConfig
import com.xebialabs.xlrelease.domain.GlobalExportConfig.validateAndNormalize

class GlobalExportConfigBuilder {
  private val config = new GlobalExportConfig

  def withNamesMatching(nameFilter: String): GlobalExportConfigBuilder = {
    config.nameFilter = nameFilter
    this
  }

  def withApplications(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.applications = enabled
    this
  }

  def withCalendars(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.calendars = enabled
    this
  }

  def withConfigurations(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.configurations = enabled
    this
  }

  def withDashboards(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.dashboards = enabled
    this
  }

  def withEnvironments(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.environments = enabled
    this
  }

  def withNotifications(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.notifications = enabled
    this
  }

  def withPermissions(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.permissions = enabled
    this
  }

  def withRiskProfiles(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.riskProfiles = enabled
    this
  }

  def withRoles(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.roles = enabled
    this
  }

  def withSettings(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.settings = enabled
    this
  }

  def withTemplates(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.templates = enabled
    this
  }

  def withWorkflows(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.workflows = enabled
    this
  }

  def withUsers(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.users = enabled
    this
  }

  def withVariables(enabled: Boolean): GlobalExportConfigBuilder = {
    config.includeKinds.variables = enabled
    this
  }

  def withAllKinds(enabled: Boolean): GlobalExportConfigBuilder = {
    withApplications(enabled)
    withCalendars(enabled)
    withConfigurations(enabled)
    withDashboards(enabled)
    withEnvironments(enabled)
    withNotifications(enabled)
    withPermissions(enabled)
    withRiskProfiles(enabled)
    withRoles(enabled)
    withSettings(enabled)
    withTemplates(enabled)
    withWorkflows(enabled)
    withUsers(enabled)
    withVariables(enabled)
  }

  def includeTemplateId(id: String): GlobalExportConfigBuilder = {
    config.includeEntities.add(id)
    this
  }

  def excludeTemplateId(id: String): GlobalExportConfigBuilder = {
    config.excludeEntities.add(id)
    this
  }

  def build(): GlobalExportConfig = {
    validateAndNormalize(config)
    config
  }
}
