package com.xebialabs.xlrelease.ascode.yaml.writer

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.ascode.yaml.writer.{GenerateContext, SpecWriter}
import com.xebialabs.xlrelease.ascode.yaml.model.EnvironmentsSpec

object EnvironmentsWriter extends SpecWriter {

  override def write(spec: Spec, yamlGenerator: YAMLGenerator)
                    (implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext = {
    val environmentsSpec = spec.asInstanceOf[EnvironmentsSpec]
    val processedEnvironment = processEnvironmentSpec(environmentsSpec)
    mapper.writeValue(yamlGenerator, processedEnvironment)
    GenerateContext(Nil, Map.empty)
  }

  private def processEnvironmentSpec(environmentsSpec: EnvironmentsSpec): EnvironmentsSpec = {
    val stages = environmentsSpec.stages
    val labels = environmentsSpec.labels
    val environments = environmentsSpec.environments
    val environmentReservations = environmentsSpec.reservations

    EnvironmentsSpec(stages, labels, environments, environmentReservations)
  }
}
