package com.xebialabs.xlrelease.ascode.service.validator

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.{Definition, UsersSpec}
import com.xebialabs.xlrelease.ascode.yaml.model.user.XLRUser
import org.springframework.stereotype.Component

@Component
class UsersSpecValidator extends SpecValidator {
  override def isDefinedAt(definition: Definition): Boolean = definition.spec.isInstanceOf[UsersSpec]

  override def apply(definition: Definition): Unit = {
    val usersSpec = definition.spec.asInstanceOf[UsersSpec]
    usersSpec.users.foreach { usr =>
      val user = usr.asInstanceOf[XLRUser]
      if (user.username == null || user.username.isEmpty) {
        throw new AsCodeException(s"The current definition is not valid. Some of the usernames are empty. All the users must have a username.")
      }
      if (user.password == null || user.password.isEmpty) {
        throw new AsCodeException(s"The current definition is not valid. Some of the passwords are empty. All the users must have a password.")
      }
    }
  }
}
