package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.xlrelease.domain.Task
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class ParallelGroupLinkReferenceCreationHandler extends CiReferenceCreationHandler {
  private val properties: Set[String] = Set("xlrelease.Link.source", "xlrelease.Link.target")

  override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean = properties.contains(helper.propertyDescriptor.getFqn)

  private def newTask(title: String): Task = {
    val task = new Task()
    task.setTitle(title)
    task
  }

  override def apply(config: CiReferenceCreationConfig): Option[AnyRef] = {
    // The actual task in the link has been removed by something, maybe the yaml parser when building the references list???
    // rebuild it as it originally was so it can be rewritten and it will actually be handled in the TemplateAsCodeParser
    config.reference.getIds.asScala.map(newTask(_)).headOption
  }
}
