package com.xebialabs.xlrelease.versioning.ascode.scm

import com.xebialabs.xlrelease.ascode.yaml.parser.ValueTagPreprocessingConstructor
import org.yaml.snakeyaml.Yaml

import scala.collection.mutable.ListBuffer

object YamlUtils {

  def preprocessYaml(yamlStr: String): List[String] = {
    val processedYamlStrs = ListBuffer.empty[String]
    val yamlParser = new Yaml(new ValueTagPreprocessingConstructor)
    val data = yamlParser.loadAll(yamlStr)
    data.forEach { spec =>
      if (spec != null) {
        processedYamlStrs.addOne(yamlParser.dump(spec))
      }
    }

    processedYamlStrs.toList
  }
}
