package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.xlrelease.domain.delivery.{Stage, Transition}
import com.xebialabs.xlrelease.service.SharedConfigurationService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class StageCiReferenceCreationHandler @Autowired()(
                                                    sharedConfigurationService: SharedConfigurationService
                                                  ) extends CiReferenceCreationHandler {
  override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean = {
    Option(helper.propertyDescriptor.getReferencedType).exists(_.instanceOf(typeOf[Transition]))
  }

  override def apply(config: CiReferenceCreationConfig): Option[AnyRef] = {
    config.ci match {
      case stage: Stage =>
        config.reference.getIds.asScala.headOption.map { title: String => {
          val transition = new Transition()
          transition.setTitle(title)
          transition.setStage(stage)
          stage.setTransition(transition)
          transition
        }
        }
      case _ => None
    }
  }
}
