package com.xebialabs.xlrelease.ascode.service.validator

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.ascode.yaml.model.permission.PermissionsSpec
import com.xebialabs.xlrelease.ascode.yaml.model.permission.TeamPermissionRelation
import org.springframework.stereotype.Component

@Component
class PermissionsSpecValidator extends SpecValidator {
  override def isDefinedAt(definition: Definition): Boolean = definition.spec.isInstanceOf[PermissionsSpec]

  override def apply(definition: Definition): Unit = {
    val permissionsSpec = definition.spec.asInstanceOf[PermissionsSpec]
    val directoriesWithInvalidCharacters = permissionsSpec.permissions.flatMap {
      case team: TeamPermissionRelation if team.directory.startsWith("/") => Some(team.directory)
      case _ => None
    }

    if (directoriesWithInvalidCharacters.nonEmpty) {
      throw new AsCodeException(s"The current definition is not valid. Some of the paths got an '/' at the beginning. The paths are: [${directoriesWithInvalidCharacters.mkString(", ")}]")
    }
  }
}
