package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.DeliveryTaskStringReferenceCreationHandler.deliveryTaskType
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.dsl.resolver.{DeliveryTaskPathResolver, DeliveryTaskToPathResolver}
import org.apache.commons.lang3.StringUtils
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters.CollectionHasAsScala

@Component
class CustomScriptTaskGeneratorHandler(deliveryTaskToPathResolver: DeliveryTaskToPathResolver) extends CiReferenceGeneratorHandler {

  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[CustomScriptTask]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val customScriptTask = ciWithHome.ci.asInstanceOf[CustomScriptTask]
    val pythonScript = customScriptTask.getPythonScript
    // Set Empty Synthetic properties to null
    val syntheticProperties = pythonScript.getAllSyntheticPropertyKeys
    val emptyValueKeys = syntheticProperties.asScala.toList.filter(key => StringUtils.EMPTY.equals(pythonScript.getProperty(key)))
    emptyValueKeys.foreach(pythonScript.setProperty(_, null))
    // Path resolution for DeliveryTask
    if (customScriptTask.getTaskType.isSubTypeOf(Type.valueOf(deliveryTaskType))) {
      deliveryTaskToPathResolver.resolve(pythonScript).foreach { case (property, change) =>
        if (DeliveryTaskPathResolver.fieldsWithFolderPath.exists(_.equals(property.getName))) property.set(pythonScript, FolderFilterGeneratorHandler.referencePath((change.newValue.getOrElse(change.oldValue)), ciWithHome.home))
        else property.set(pythonScript, change.newValue.getOrElse(change.oldValue))
      }
    }

  }
}
