package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.domain.ReleaseTrigger
import com.xebialabs.xlrelease.variable.VariableHelper
import org.springframework.stereotype.Component

import scala.util.Try

@Component
class ReleaseTriggerGeneratorHandler extends CiReferenceGeneratorHandler {

  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[ReleaseTrigger]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val releaseTrigger = ci.asInstanceOf[ReleaseTrigger]
    Try {
      Option(releaseTrigger.getReleaseFolder).filterNot(VariableHelper.containsVariables).
        map(folderId => FolderFilterGeneratorHandler.referencePath(folderId, ciWithHome.home))
    }.recover { case _: Exception => Some(null) }.toOption.flatten.foreach(releaseTrigger.setReleaseFolder)
  }
}
