package com.xebialabs.xlrelease.versioning.ascode.scm.strategy

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Component
class VersioningStyleResolver @Autowired() (versioningStrategies: JList[VersioningStyleStrategy]) {

  lazy val supportedStyles: Map[String, String] = versioningStrategies.asScala.map(str => str.name -> str.value).toMap

  def resolve(versioningStyle: String): VersioningStyleStrategy = {
    versioningStrategies.asScala.filter(strategy => strategy.name.equals(versioningStyle)).head
  }

}
