package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.api.v1.RiskApi
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.risk.domain.RiskProfile
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.collection.immutable.ListMap
import scala.jdk.CollectionConverters._


@Component
class RiskProfileAsCodeGenerator @Autowired()(riskApi: RiskApi) extends GenerateStrategy[RiskProfile] {
  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateRiskProfiles
  }

  override val generateOrder: Double = 0

  override protected def generateGlobal(config: CiGenerateConfig): ListMap[Option[Folder], List[RiskProfile]] = {
    ListMap(None -> riskApi.getRiskProfiles.asScala.toList)
  }
}
