/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.xlrelease.api.internal.CalendarResource;
import com.xebialabs.xlrelease.ascode.yaml.model.CalendarAsCode;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0005\u001d4A\u0001B\u0003\u0001!!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003=\u0001\u0011\u0005QHA\u000bDC2,g\u000eZ1s\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u000b\u0005\u00199\u0011aB:feZL7-\u001a\u0006\u0003\u0011%\ta!Y:d_\u0012,'B\u0001\u0006\f\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\r\u001b\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001d\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!E\f\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tAR$D\u0001\u001a\u0015\tQ2$A\u0003tY\u001a$$NC\u0001\u001d\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0010\u001a\u0005\u001daunZ4j]\u001e\f\u0001cY1mK:$\u0017M\u001d*fg>,(oY3\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u0015J\u0011aA1qS&\u0011qE\t\u0002\u0011\u0007\u0006dWM\u001c3beJ+7o\\;sG\u0016\fa\u0001P5oSRtDC\u0001\u0016-!\tY\u0003!D\u0001\u0006\u0011\u0015y\"\u00011\u0001!Q\t\u0011a\u0006\u0005\u00020u5\t\u0001G\u0003\u00022e\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005M\"\u0014a\u00024bGR|'/\u001f\u0006\u0003kY\nQAY3b]NT!a\u000e\u001d\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!O\u0001\u0004_J<\u0017BA\u001e1\u0005%\tU\u000f^8xSJ,G-A\u000bva\u0012\fG/Z\"bY\u0016tG-\u0019:F]R\u0014\u0018.Z:\u0015\u0005y:\u0006CA U\u001d\t\u0001\u0015K\u0004\u0002B\u001d:\u0011!i\u0013\b\u0003\u0007*s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001d{\u0011A\u0002\u001fs_>$h(C\u0001\u000f\u0013\taQ\"\u0003\u0002\t\u0017%\u0011A*T\u0001\u0005s\u0006lGN\u0003\u0002\t\u0017%\u0011q\nU\u0001\u0004IR|'B\u0001'N\u0013\t\u00116+\u0001\bBg\u000e{G-\u001a*fgB|gn]3\u000b\u0005=\u0003\u0016BA+W\u0005)\u0019\u0005.\u00198hK\u0012LEm\u001d\u0006\u0003%NCQ\u0001W\u0002A\u0002e\u000babY1mK:$\u0017M]!t\u0007>$W\r\u0005\u0002[=6\t1L\u0003\u0002];\u0006)Qn\u001c3fY*\u0011AjB\u0005\u0003?n\u0013abQ1mK:$\u0017M]!t\u0007>$W\r\u000b\u0002\u0001CB\u0011!-Z\u0007\u0002G*\u0011AMN\u0001\u000bgR,'/Z8usB,\u0017B\u00014d\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class CalendarAsCodeService
implements Logging {
    private final CalendarResource calendarResource;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CalendarAsCodeService calendarAsCodeService = this;
        synchronized (calendarAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public AsCodeResponse.ChangedIds updateCalendarEntries(CalendarAsCode calendarAsCode) {
        ObjectRef createdCalendarEntries = ObjectRef.create((Object)new ListBuffer());
        ObjectRef updatedCalendarEntries = ObjectRef.create((Object)new ListBuffer());
        calendarAsCode.calendar().forEach(c -> {
            Date now = new Date();
            Date normalizedNow = new DateTime((Object)now).withTimeAtStartOfDay().toDate();
            c.blackouts().forEach(blackout -> {
                if (blackout.getEndDate().before(now)) {
                    throw new AsCodeException(new StringBuilder(55).append("Blackout ").append(blackout.getLabel()).append(" from [").append(blackout.getStartDate()).append("] to [").append(blackout.getEndDate()).append("] must end after the current date").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            c.specialDays().forEach(specialDay -> {
                specialDay.setStartDate(new DateTime((Object)specialDay.getStartDate()).withTimeAtStartOfDay().toDate());
                if (specialDay.getStartDate().before(normalizedNow)) {
                    throw new AsCodeException(new StringBuilder(47).append("Special day ").append(specialDay.getLabel()).append(" at [").append(specialDay.getStartDate()).append("] must be today or future date").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            if (!c.blackouts().isEmpty()) {
                this.logger().debug((Function0 & Serializable)() -> "Updating calendar blackouts");
                c.blackouts().forEach(blackout -> {
                    $this.calendarResource.addBlackout(blackout);
                    ((ListBuffer)createdCalendarEntries$1.elem).$plus$eq((Object)blackout.getId());
                });
            }
            if (!c.specialDays().isEmpty()) {
                this.logger().debug((Function0 & Serializable)() -> "Updating calendar special days");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                c.specialDays().forEach(specialDay -> {
                    SpecialDay newSpecialDay = new SpecialDay(specialDay.getLabel(), specialDay.getColor());
                    String id = dateFormat.format(specialDay.getStartDate());
                    String specialDayId = new StringBuilder(23).append("Configuration/Calendar/").append(id).toString();
                    $this.calendarResource.setSpecialDay(specialDayId, newSpecialDay);
                    ((ListBuffer)updatedCalendarEntries$1.elem).$plus$eq((Object)specialDayId);
                });
                return;
            }
        });
        return AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(((ListBuffer)createdCalendarEntries.elem).toList()).withUpdated(((ListBuffer)updatedCalendarEntries.elem).toList());
    }

    @Autowired
    public CalendarAsCodeService(CalendarResource calendarResource) {
        this.calendarResource = calendarResource;
        Logging.$init$((Logging)this);
    }
}

