/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.ImportResult$;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.service.spec.CiSpecInterpreter;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.GlobalVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.GlobalVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0006\f\u0001YA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015Y\u0007\u0001\"\u0003m\u0011\u0015\u0011\b\u0001\"\u0003t\u0011\u00151\b\u0001\"\u0003x\u0005m9En\u001c2bYZ\u000b'/[1cY\u0016\f5oQ8eKN+'O^5dK*\u0011A\"D\u0001\bg\u0016\u0014h/[2f\u0015\tqq\"\u0001\u0004bg\u000e|G-\u001a\u0006\u0003!E\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005I\u0019\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005!\u0012aA2p[\u000e\u00011c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\u000bMdg\r\u000e6\u000b\u0003\t\n\u0001b\u001a:jujdW\rZ\u0005\u0003I}\u0011q\u0001T8hO&tw-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011qEK\u0007\u0002Q)\u0011\u0011fD\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0016)\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\bsK\u001a,'/\u001a8dKN{GN^3s!\tqs&D\u0001\f\u0013\t\u00014BA\bSK\u001a,'/\u001a8dKN{GN^3s\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005M*T\"\u0001\u001b\u000b\u00051y\u0011B\u0001\u001c5\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0011\u00154XM\u001c;CkN\u0004\"!\u000f\u001f\u000e\u0003iR!aO\b\u0002\r\u00154XM\u001c;t\u0013\ti$HA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\fa\u0001P5oSRtD#\u0002!B\u0005\u000e#\u0005C\u0001\u0018\u0001\u0011\u0015)S\u00011\u0001'\u0011\u0015aS\u00011\u0001.\u0011\u0015\tT\u00011\u00013\u0011\u00159T\u00011\u00019Q\t)a\t\u0005\u0002H%6\t\u0001J\u0003\u0002J\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005-c\u0015a\u00024bGR|'/\u001f\u0006\u0003\u001b:\u000bQAY3b]NT!a\u0014)\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!U\u0001\u0004_J<\u0017BA*I\u0005%\tU\u000f^8xSJ,G-A\u0004qe>\u001cWm]:\u0015\u0007YK\u0016\r\u0005\u0002//&\u0011\u0001l\u0003\u0002\r\u00136\u0004xN\u001d;SKN,H\u000e\u001e\u0005\u00065\u001a\u0001\raW\u0001\bG>tG/\u001a=u!\tav,D\u0001^\u0015\tqV\"A\u0003vi&d7/\u0003\u0002a;\ni\u0011*\u001c9peR\u001cuN\u001c;fqRDQA\u0019\u0004A\u0002\r\f\u0001B^1sS\u0006\u0014G.\u001a\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f\u0011B^1sS\u0006\u0014G.Z:\u000b\u0005!|\u0011A\u00023p[\u0006Lg.\u0003\u0002kK\nAa+\u0019:jC\ndW-\u0001\u0003gS:$GcA7qcB\u0019\u0001D\\2\n\u0005=L\"AB(qi&|g\u000eC\u0003[\u000f\u0001\u00071\fC\u0003c\u000f\u0001\u00071-\u0001\u0004de\u0016\fG/\u001a\u000b\u0004GR,\b\"\u0002.\t\u0001\u0004Y\u0006\"\u00022\t\u0001\u0004\u0019\u0017AB;qI\u0006$X\r\u0006\u0003dqf\\\b\"\u0002.\n\u0001\u0004Y\u0006\"\u0002>\n\u0001\u0004\u0019\u0017\u0001C3ySN$\u0018N\\4\t\u000b\tL\u0001\u0019A2)\u0005\u0001i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u00029\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\r\t)a \u0002\b'\u0016\u0014h/[2f\u0001")
public class GlobalVariableAsCodeService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final ReferenceSolver referenceSolver;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        GlobalVariableAsCodeService globalVariableAsCodeService = this;
        synchronized (globalVariableAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Variable variable) {
        CiSpecInterpreter.ProcessedCi<Variable> processedCi;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Processing global variable: ").append(variable.toString()).append(" with metadata ").append(context.metadata().toString()).toString());
        this.referenceSolver.resolveReferences((ConfigurationItem)variable, context.references(), null);
        Option<Variable> option = this.find(context, variable);
        if (option instanceof Some) {
            Some some = (Some)option;
            Variable existing = (Variable)some.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Updating global variable: ").append(existing.toString()).toString());
            Variable updated = this.update(context, existing, variable);
            processedCi = new CiSpecInterpreter.ProcessedCi<Variable>(updated, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new GlobalVariableUpdatedEvent(existing, updated, null))}))));
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Creating global variable: ").append(variable.toString()).toString());
            Variable created = this.create(context, variable);
            processedCi = new CiSpecInterpreter.ProcessedCi<Variable>(created, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new GlobalVariableCreatedEvent(created, null))}))));
        } else {
            throw new MatchError(option);
        }
        CiSpecInterpreter.ProcessedCi<Variable> processed = processedCi;
        return new ImportResult((List<AsCodeResponse.ChangedIds>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsCodeResponse.ChangedIds[]{processed.changedIds()}))), processed.postCommitActions(), ImportResult$.MODULE$.apply$default$3(), ImportResult$.MODULE$.apply$default$4());
    }

    private Option<Variable> find(ImportContext context, Variable variable) {
        VariablePersistenceHelper$.MODULE$.fixUpPrefix(variable, "global");
        String title = variable.getKey();
        List matches = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(Type.valueOf(Variable.class))).asScala().toList().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)GlobalVariableAsCodeService.$anonfun$find$1(title, v)));
        if (matches.length() > 1) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(58).append("There are multiple global variables named [").append(title).append("] ").append(context.scope().description()).append(", those are: ").append(matches.toString()).toString());
            throw new AsCodeException(new StringBuilder(79).append("Multiple global variables are named [").append(title).append("] ").append(context.scope().description()).append(". Can not determine which one to update.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return matches.headOption();
    }

    private Variable create(ImportContext context, Variable variable) {
        VariablePersistenceHelper$.MODULE$.fixUpGlobalVariable(variable, this.ciIdService);
        return (Variable)this.configurationRepository.create((BaseConfiguration)variable);
    }

    private Variable update(ImportContext context, Variable existing, Variable variable) {
        VariablePersistenceHelper$.MODULE$.checkSameType(variable, existing);
        variable.setId(existing.getId());
        VariablePersistenceHelper$.MODULE$.fixUpGlobalVariable(variable, this.ciIdService);
        return (Variable)this.configurationRepository.update((BaseConfiguration)variable);
    }

    public static final /* synthetic */ boolean $anonfun$find$1(String title$1, Variable v) {
        return v.getKey().equals(title$1);
    }

    @Autowired
    public GlobalVariableAsCodeService(ConfigurationRepository configurationRepository, ReferenceSolver referenceSolver, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.referenceSolver = referenceSolver;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

