/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.writer.DefinitionWriter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.CreationService;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService;
import com.xebialabs.xlrelease.ascode.service.FolderSearch;
import com.xebialabs.xlrelease.ascode.service.FolderSearch$;
import com.xebialabs.xlrelease.ascode.service.GenerateService;
import com.xebialabs.xlrelease.ascode.service.GenerateService$CisConfig$;
import com.xebialabs.xlrelease.ascode.service.GenerateService$GeneratorConfig$;
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter$;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.JGitConnector$;
import com.xebialabs.xlrelease.scm.connector.Repository;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.scm.data.GitTag;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo$;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Exception;
import scala.util.control.Exception$;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\teh\u0001\u0002\u0013&\u0001IB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011\u001d\u0004!\u0011!Q\u0001\n!D\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\t_\u0002\u0011\t\u0011)A\u0005a\"A1\u000f\u0001B\u0001B\u0003%A\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003y\u0011\u0015Y\b\u0001\"\u0001}\u0011%\t\u0019\u0004\u0001b\u0001\n\u0013\t)\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\u001c\u0011)\t\t\u0006\u0001EC\u0002\u0013\u0005\u00111\u000b\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!a.\u0001\t\u0003\tI\fC\u0005\u0002J\u0002\t\n\u0011\"\u0001\u0002L\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u00119\u0003\u0001C\u0001\u0005SAqA!\u000e\u0001\t\u0003\u00119\u0004C\u0004\u0003>\u0001!\tAa\u0010\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003J!9!1\f\u0001\u0005\n\tu\u0003b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u0011I\n\u0001C\u0005\u00057CqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u00032\u0002!IAa-\t\u000f\te\u0006\u0001\"\u0003\u0003<\"9!1\u001c\u0001\u0005\n\tu\u0007b\u0002Bs\u0001\u0011%!q\u001d\u0002\u0018\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cVM\u001d<jG\u0016T!AJ\u0014\u0002\u0007M\u001cWN\u0003\u0002)S\u00051\u0011m]2pI\u0016T!AK\u0016\u0002\u0015Y,'o]5p]&twM\u0003\u0002-[\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003]=\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003A\n1aY8n\u0007\u0001\u00192\u0001A\u001a:!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fMB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0006g24GG\u001b\u0006\u0002}\u0005AqM]5{u2,G-\u0003\u0002Aw\t9Aj\\4hS:<\u0017AE;tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u0011$\u000e\u0003\u0011S!!R\u0016\u0002\u000fM,'O^5dK&\u0011q\t\u0012\u0002\u0013+N,'\u000f\u0015:pM&dWmU3sm&\u001cW-A\bhK:,'/\u0019;f'\u0016\u0014h/[2f!\tQU*D\u0001L\u0015\t)EJ\u0003\u0002)W%\u0011aj\u0013\u0002\u0010\u000f\u0016tWM]1uKN+'O^5dK\u0006y1M]3bi&|gnU3sm&\u001cW\r\u0005\u0002K#&\u0011!k\u0013\u0002\u0010\u0007J,\u0017\r^5p]N+'O^5dK\u0006\u0001B-\u001a4j]&$\u0018n\u001c8QCJ\u001cXM\u001d\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000ba\u0001]1sg\u0016\u0014(BA-M\u0003\u0011I\u0018-\u001c7\n\u0005m3&a\u0005-M%\u0012+g-\u001b8ji&|g\u000eU1sg\u0016\u0014\u0018aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\tq\u0016-D\u0001`\u0015\t\u00017&\u0001\u0006sKB|7/\u001b;pefL!AY0\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018\u0001H2p]\u001aLw-\u001e:bi&|gNV1sS\u0006\u0014G.Z*feZL7-\u001a\t\u0003\u0007\u0016L!A\u001a#\u00039\r{gNZ5hkJ\fG/[8o-\u0006\u0014\u0018.\u00192mKN+'O^5dK\u0006!2m\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"aQ5\n\u0005)$%\u0001F\"p]\u001aLw-\u001e:bi&|gnU3sm&\u001cW-A\ng_2$WM]!t\u0007>$WmU3sm&\u001cW\r\u0005\u0002K[&\u0011an\u0013\u0002\u0014\r>dG-\u001a:Bg\u000e{G-Z*feZL7-Z\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f!\t\u0019\u0015/\u0003\u0002s\t\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"aQ;\n\u0005Y$%aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fQBZ8mI\u0016\u00148+\u001a:wS\u000e,\u0007CA\"z\u0013\tQHIA\u0007G_2$WM]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015-u|\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'\u0001\"A \u0001\u000e\u0003\u0015BQ!\u0011\u0007A\u0002\tCQ\u0001\u0013\u0007A\u0002%CQa\u0014\u0007A\u0002ACQa\u0015\u0007A\u0002QCQ\u0001\u0018\u0007A\u0002uCQa\u0019\u0007A\u0002\u0011DQa\u001a\u0007A\u0002!DQa\u001b\u0007A\u00021DQa\u001c\u0007A\u0002ADQa\u001d\u0007A\u0002QDQa\u001e\u0007A\u0002aD3\u0001DA\f!\u0011\tI\"a\f\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t!\"\u00198o_R\fG/[8o\u0015\u0011\t\t#a\t\u0002\u000f\u0019\f7\r^8ss*!\u0011QEA\u0014\u0003\u0015\u0011W-\u00198t\u0015\u0011\tI#a\u000b\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\f\u0002\u0007=\u0014x-\u0003\u0003\u00022\u0005m!!C!vi><\u0018N]3e\u0003\u0019\u0019\u0017\u000eV=qKV\u0011\u0011q\u0007\t\u0005\u0003s\tY%\u0004\u0002\u0002<)!\u0011QHA \u0003\u001d\u0011XM\u001a7fGRTA!!\u0011\u0002D\u0005\u0019\u0011\r]5\u000b\t\u0005\u0015\u0013qI\u0001\u0007a2,x-\u001b8\u000b\u0007\u0005%S&\u0001\u0005eKBdw._5u\u0013\u0011\ti%a\u000f\u0003\tQK\b/Z\u0001\bG&$\u0016\u0010]3!\u000399(/\u00199Fq\u000e,\u0007\u000f^5p]N,\"!!\u0016\u0011\r\u0005]\u0013qOA?\u001d\u0011\tI&!\u001d\u000f\t\u0005m\u00131\u000e\b\u0005\u0003;\n9G\u0004\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019'M\u0001\u0007yI|w\u000e\u001e \n\u0003YJ1!!\u001b6\u0003\u0011)H/\u001b7\n\t\u00055\u0014qN\u0001\bG>tGO]8m\u0015\r\tI'N\u0005\u0005\u0003g\n)(A\u0005Fq\u000e,\u0007\u000f^5p]*!\u0011QNA8\u0013\u0011\tI(a\u001f\u0003\u000b\r\u000bGo\u00195\u000b\t\u0005M\u0014Q\u000f\t\u0004i\u0005}\u0014bAAAk\t9aj\u001c;iS:<\u0017\u0001\u00044j]\u0012\u001cV\r\u001e;j]\u001e\u001cH\u0003BAD\u0003;\u0003R\u0001NAE\u0003\u001bK1!a#6\u0005\u0019y\u0005\u000f^5p]B!\u0011qRAM\u001b\t\t\tJC\u0002)\u0003'S1AKAK\u0015\r\t9jK\u0001\u0007I>l\u0017-\u001b8\n\t\u0005m\u0015\u0011\u0013\u0002\u0019\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cV\r\u001e;j]\u001e\u001c\bbBAP!\u0001\u0007\u0011\u0011U\u0001\tM>dG-\u001a:JIB!\u00111UAV\u001d\u0011\t)+a*\u0011\u0007\u0005}S'C\u0002\u0002*V\na\u0001\u0015:fI\u00164\u0017\u0002BAW\u0003_\u0013aa\u0015;sS:<'bAAUk\u0005Yq-\u001a;TKR$\u0018N\\4t)\u0011\ti)!.\t\u000f\u0005}\u0015\u00031\u0001\u0002\"\u000612M]3bi\u0016|%/\u00169eCR,7+\u001a;uS:<7\u000f\u0006\u0004\u0002\u000e\u0006m\u0016q\u0018\u0005\b\u0003{\u0013\u0002\u0019AAG\u0003%qWm^\"p]\u001aLw\rC\u0005\u0002BJ\u0001\n\u00111\u0001\u0002D\u0006\t\"/Z7pi\u00164\u0016\r\\5eCRLwN\\:\u0011\u0007Q\n)-C\u0002\u0002HV\u0012qAQ8pY\u0016\fg.\u0001\u0011de\u0016\fG/Z(s+B$\u0017\r^3TKR$\u0018N\\4tI\u0011,g-Y;mi\u0012\u0012TCAAgU\u0011\t\u0019-a4,\u0005\u0005E\u0007\u0003BAj\u00037l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\b6\u0013\u0011\ti.!6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\beK2,G/Z*fiRLgnZ:\u0015\t\u0005\r\u0018\u0011\u001e\t\u0004i\u0005\u0015\u0018bAAtk\t!QK\\5u\u0011\u001d\ty\n\u0006a\u0001\u0003C\u000b1bZ3u-\u0016\u00148/[8ogR!\u0011q\u001eB\u0010!\u001d!\u0014\u0011_A{\u0005\u0007I1!a=6\u0005\u0019!V\u000f\u001d7feA!\u0011q_A\u0000\u001b\t\tIP\u0003\u0003\u0002j\u0005m(BAA\u007f\u0003\u0011Q\u0017M^1\n\t\t\u0005\u0011\u0011 \u0002\u0005\t\u0006$X\r\u0005\u0004\u0003\u0006\t-!\u0011\u0003\b\u0005\u0003;\u00129!C\u0002\u0003\nU\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u000e\t=!aA*fc*\u0019!\u0011B\u001b\u0011\t\tM!1D\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u0005!A-\u0019;b\u0015\t13&\u0003\u0003\u0003\u001e\tU!a\u0003,feNLwN\\%oM>Dq!a(\u0016\u0001\u0004\t\t+\u0001\u0007gKR\u001c\u0007n\u00115b]\u001e,7\u000f\u0006\u0003\u0002p\n\u0015\u0002bBAP-\u0001\u0007\u0011\u0011U\u0001\u000eGJ,\u0017\r^3WKJ\u001c\u0018n\u001c8\u0015\u0011\tE!1\u0006B\u0017\u0005cAq!a(\u0018\u0001\u0004\t\t\u000bC\u0004\u00030]\u0001\r!!)\u0002\u000fY,'o]5p]\"9!1G\fA\u0002\u0005\u0005\u0016a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\fA\"\u00199qYf4VM]:j_:$b!a9\u0003:\tm\u0002bBAP1\u0001\u0007\u0011\u0011\u0015\u0005\b\u0005_A\u0002\u0019AAQ\u0003=9WM\\3sCR,\u0007K]3wS\u0016<HCBAQ\u0005\u0003\u0012\u0019\u0005C\u0004\u0002 f\u0001\r!!)\t\u000f\t=\u0012\u00041\u0001\u0003FA)A'!#\u0002\"\u0006i\u0011N\\5u\u0007>tg.Z2u_J$BAa\u0013\u0003XA!!Q\nB*\u001b\t\u0011yEC\u0002\u0003R\u0015\n\u0011bY8o]\u0016\u001cGo\u001c:\n\t\tU#q\n\u0002\u0014\u0003N\u001cu\u000eZ3K\u000f&$8i\u001c8oK\u000e$xN\u001d\u0005\b\u00053R\u0002\u0019AAG\u0003\u0019\u0019wN\u001c4jO\u0006qq-\u001a8fe\u0006$XMR8mI\u0016\u0014H\u0003\u0003B0\u0005\u0003\u0013\u0019I!\"\u0011\u000fQ\n\tP!\u0019\u0003lA!!1\rB4\u001b\t\u0011)G\u0003\u0003\u0003R\te\u0011\u0002\u0002B5\u0005K\u0012\u0001bU2n\u00052|'m\u001d\t\u0007\u0005\u000b\u0011iG!\u001d\n\t\t=$q\u0002\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0003t\tuTB\u0001B;\u0015\u0011\u00119H!\u001f\u0002\u000b5|G-\u001a7\u000b\u0007e\u0013YH\u0003\u0002)[%!!q\u0010B;\u0005)!UMZ5oSRLwN\u001c\u0005\b\u0003?[\u0002\u0019AAQ\u0011\u001d\u0011If\u0007a\u0001\u0003\u001bCqAa\"\u001c\u0001\u0004\t\t+\u0001\u0005gS2,\u0007+\u0019;i\u0003A1\u0018\r\\5eCR,7+\u001a;uS:<7\u000f\u0006\u0004\u0002d\n5%q\u0012\u0005\b\u00053b\u0002\u0019AAG\u0011\u001d\t\t\r\ba\u0001\u0003\u0007\fQC^1mS\u0012\fG/Z*qK\u000eLg-[2bi&|g\u000e\u0006\u0003\u0002d\nU\u0005b\u0002BL;\u0001\u0007\u0011\u0011U\u0001\u0005gB,7-A\u0006nKR\fG-\u0019;b\u001b\u0006\u0004H\u0003\u0002BO\u0005K\u0003R\u0001NAE\u0005?\u0003\u0002\"a)\u0003\"\u0006\u0005\u0016\u0011U\u0005\u0005\u0005G\u000byKA\u0002NCBDq!a(\u001f\u0001\u0004\t\t+\u0001\u0007fqR\u0014\u0018m\u0019;Ta\u0016\u001c7\u000f\u0006\u0003\u0003,\n5\u0006C\u0002B\u0003\u0005\u0017\t\t\u000bC\u0004\u00030~\u0001\rA!\u0019\u0002\u000b\tdwNY:\u0002\u001b5\f'o[!t\u0003B\u0004H.[3e)\u0019\t\u0019O!.\u00038\"9!q\u0006\u0011A\u0002\u0005\u0005\u0006b\u0002B-A\u0001\u0007\u0011QR\u0001\u001aCB\u0004H._*d[\u0012\u000bG/\u0019+p\t\u00164\u0017N\\5uS>t7\u000f\u0006\u0004\u0002d\nu&1\u0019\u0005\b\u0005\u007f\u000b\u0003\u0019\u0001Ba\u0003-!WMZ5oSRLwN\\:\u0011\r\t\u0015!1\u0002B9\u0011\u001d\u0011)-\ta\u0001\u0005\u000f\fqa]2n\t\u0006$\u0018\r\u0005\u0003\u0003J\n]WB\u0001Bf\u0015\u0011\u0011iMa4\u0002\u0007\u0011$xN\u0003\u0003\u0003R\nM\u0017aA2pG*\u0019!Q[\u0017\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u0003\u0003Z\n-'aE*D\u001bR\u0013\u0018mY3bE&d\u0017\u000e^=ECR\f\u0017AF4fiN\u001bW\u000e\u0016:bG\u0016\f'-\u001b7jif$\u0015\r^1\u0015\r\t\u001d'q\u001cBq\u0011\u001d\u0011IF\ta\u0001\u0003\u001bCqAa9#\u0001\u0004\u0011\t\"A\u0006wKJ\u001c\u0018n\u001c8J]\u001a|\u0017\u0001\u0007:fg>dg/\u001a$pY\u0012,'\u000fV5uY\u00164%o\\7JIR!\u0011\u0011\u0015Bu\u0011\u001d\tyj\ta\u0001\u0003CC3\u0001\u0001Bw!\u0011\u0011yO!>\u000e\u0005\tE(\u0002\u0002Bz\u0003O\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00119P!=\u0003\u000fM+'O^5dK\u0002")
public class FolderVersioningService
implements Logging {
    private Exception.Catch<Nothing$> wrapExceptions;
    private final UserProfileService userProfileService;
    private final GenerateService generateService;
    private final CreationService creationService;
    private final XLRDefinitionParser definitionParser;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationVariableService configurationVariableService;
    private final ConfigurationService configurationService;
    private final FolderAsCodeService folderAsCodeService;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final FolderService folderService;
    private final Type ciType;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Type ciType() {
        return this.ciType;
    }

    private Exception.Catch<Nothing$> wrapExceptions$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$0) {
                this.wrapExceptions = Exception$.MODULE$.catchingPromiscuously((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{AsCodeException.class, GitAPIException.class, JGitInternalException.class})).withApply((Function1 & Serializable)e -> {
                    throw new ScmException(new StringBuilder(44).append("Error performing version control operation: ").append(e.getMessage()).toString(), e.getCause(), ScmException$.MODULE$.apply$default$3());
                });
                this.bitmap$0 = true;
            }
        }
        return this.wrapExceptions;
    }

    public Exception.Catch<Nothing$> wrapExceptions() {
        return !this.bitmap$0 ? this.wrapExceptions$lzycompute() : this.wrapExceptions;
    }

    public Option<FolderVersioningSettings> findSettings(String folderId) {
        return (Option)this.wrapExceptions().apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala($this.configurationRepository.findAllByTypeAndTitle(this.ciType(), null, folderId, true)).asScala().headOption());
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)((Object)((Object)this.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("No version control settings defined for folder", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        })))));
    }

    public FolderVersioningSettings createOrUpdateSettings(FolderVersioningSettings newConfig, boolean remoteValidations) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings folderVersioningSettings;
            this.validateSettings(newConfig, remoteValidations);
            Option<FolderVersioningSettings> option = this.findSettings(newConfig.getFolderId());
            if (option instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings existingConfig = (FolderVersioningSettings)((Object)((Object)some.value()));
                existingConfig.updateWith(newConfig);
                folderVersioningSettings = existingConfig;
            } else if (None$.MODULE$.equals(option)) {
                newConfig.setId($this.ciIdService.getUniqueId(this.ciType(), FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_ID_ROOT()));
                folderVersioningSettings = newConfig;
            } else {
                throw new MatchError(option);
            }
            FolderVersioningSettings config = folderVersioningSettings;
            $this.configurationService.createOrUpdate((BaseConfiguration)config);
            return config;
        }));
    }

    public boolean createOrUpdateSettings$default$2() {
        return true;
    }

    public void deleteSettings(String folderId) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option<FolderVersioningSettings> option = this.findSettings(folderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings config = (FolderVersioningSettings)((Object)((Object)some.value()));
                $this.configurationRepository.delete(config.getId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> getVersions(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.listVersions();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$1 -> x$1.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> fetchChanges(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.pullAndListVersions();
            config.lastFetched_$eq(new Date());
            $this.configurationRepository.update((BaseConfiguration)config);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$2 -> x$2.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public VersionInfo createVersion(String folderId, String version, String description) {
        return (VersionInfo)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            Tuple2<ScmBlobs, List<Definition>> tuple2 = this.generateFolder(folderId, config, filePath);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ScmBlobs blobs = (ScmBlobs)tuple2._1();
            List definitions = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)blobs, (Object)definitions);
            Tuple2 tuple23 = tuple22;
            ScmBlobs blobs2 = (ScmBlobs)tuple23._1();
            List definitions2 = (List)tuple23._2();
            GitTag tag = new GitTag((String)FolderVersioningSettings$.MODULE$.generateTagName(config.getEffectiveTagPrefix(), version, FolderVersioningSettings$.MODULE$.generateTagName$default$3()).get());
            ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, tag).get();
            UserProfile userProfile = $this.userProfileService.findByUsername(Permissions.getAuthenticatedUserName());
            scmConnector.createNewVersion(blobs2, commitInfo, userProfile).get();
            VersionInfo versionInfo = scmConnector.getVersion(commitInfo.tag().refName());
            SCMTraceabilityData scmData = this.getScmTraceabilityData(config, versionInfo);
            this.markAsApplied(versionInfo.name(), config);
            this.applyScmDataToDefinitions((Seq<Definition>)definitions2, scmData);
            return versionInfo;
        });
    }

    public void applyVersion(String folderId, String version) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            VersionInfo versionInfo = scmConnector.getVersion(version);
            SCMTraceabilityData scmData = this.getScmTraceabilityData(config, versionInfo);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            ScmBlobs blobs = (ScmBlobs)scmConnector.checkout(filePath, version, scmConnector.checkout$default$3()).get();
            Seq<String> specs = this.extractSpecs(blobs);
            specs.foreach((Function1 & Serializable)spec -> {
                this.validateSpecification((String)spec);
                Definition definition = $this.definitionParser.parse((String)spec);
                Definition updatedDefinition = new Definition(definition.apiVersion(), this.metadataMap(folderId), definition.kind(), definition.spec());
                return $this.creationService.processBlueprint(updatedDefinition, scmData);
            });
            this.markAsApplied(version, config);
        });
    }

    public String generatePreview(String folderId, Option<String> version) {
        return (String)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            ScmBlobs scmBlobs;
            FolderVersioningSettings config = this.getSettings(folderId);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                AsCodeJGitConnector scmConnector = this.initConnector(config);
                scmBlobs = (ScmBlobs)scmConnector.checkout(filePath, ver, false).get();
            } else if (None$.MODULE$.equals(option)) {
                scmBlobs = (ScmBlobs)this.generateFolder(folderId, config, filePath)._1();
            } else {
                throw new MatchError((Object)option);
            }
            ScmBlobs blobs = scmBlobs;
            return new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    public AsCodeJGitConnector initConnector(FolderVersioningSettings config) {
        Repository connectorConfig = config.gitConnection();
        this.configurationVariableService.resolve((Configuration)connectorConfig);
        return new AsCodeJGitConnector(config);
    }

    private Tuple2<ScmBlobs, List<Definition>> generateFolder(String folderId, FolderVersioningSettings config, String filePath) {
        Tuple2 tuple2;
        boolean x$1 = config.exportConfiguration();
        boolean x$2 = config.exportDashboards();
        boolean x$3 = config.exportTemplates();
        boolean x$4 = config.exportTriggers();
        boolean x$5 = config.exportVariables();
        boolean x$6 = config.exportPatterns();
        boolean x$7 = config.exportNotifications();
        boolean x$8 = config.exportSecurity();
        boolean x$9 = GenerateService$CisConfig$.MODULE$.apply$default$2();
        boolean x$10 = GenerateService$CisConfig$.MODULE$.apply$default$3();
        boolean x$11 = GenerateService$CisConfig$.MODULE$.apply$default$4();
        boolean x$12 = GenerateService$CisConfig$.MODULE$.apply$default$5();
        boolean x$13 = GenerateService$CisConfig$.MODULE$.apply$default$6();
        boolean x$14 = GenerateService$CisConfig$.MODULE$.apply$default$12();
        boolean x$15 = GenerateService$CisConfig$.MODULE$.apply$default$13();
        boolean x$16 = GenerateService$CisConfig$.MODULE$.apply$default$16();
        boolean x$17 = GenerateService$CisConfig$.MODULE$.apply$default$17();
        GenerateService.CisConfig cisConfig = new GenerateService.CisConfig(x$8, x$9, x$10, x$11, x$12, x$13, x$3, x$4, x$6, x$2, x$1, x$14, x$15, x$5, x$7, x$16, x$17);
        try {
            FolderSearch scope = FolderSearch$.MODULE$.apply(this.folderAsCodeService.getFolderPath(folderId), folderId, true);
            List<Definition> definitions = this.generateService.generate(new GenerateService.GeneratorConfig((Option<String>)None$.MODULE$, scope, cisConfig, GenerateService$GeneratorConfig$.MODULE$.apply$default$4()));
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XLRDefinitionWriter qual$1 = XLRDefinitionWriter$.MODULE$.apply();
            ByteArrayOutputStream x$18 = stream;
            DefinitionWriter.WriterConfig x$19 = new DefinitionWriter.WriterConfig(definitions, false, false);
            boolean x$20 = qual$1.writeYaml$default$3();
            qual$1.writeYaml(x$18, x$19, x$20);
            tuple2 = new Tuple2((Object)new ScmBlobs((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BinaryFile[]{new BinaryFile(filePath, (Function0 & Serializable)() -> stream.toByteArray())}))), definitions);
        }
        catch (AsCodeException e) {
            throw new ScmException(e.getMessage(), e.getCause(), ScmException$.MODULE$.apply$default$3());
        }
        return tuple2;
    }

    private void validateSettings(FolderVersioningSettings config, boolean remoteValidations) {
        block3: {
            if (StringUtils.isBlank((CharSequence)config.scmPath())) {
                throw new AsCodeException(new StringBuilder(80).append("Can't create version control configurations for folder ").append(this.resolveFolderTitleFromId(config.getFolderId())).append(", scmPath cannot be blank").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            if (StringUtils.isBlank((CharSequence)config.tagPrefix())) {
                throw new AsCodeException(new StringBuilder(82).append("Can't create version control configurations for folder ").append(this.resolveFolderTitleFromId(config.getFolderId())).append(", tagPrefix cannot be blank").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            AsCodeJGitConnector connector = this.initConnector(config);
            String url = connector.getConnectionSettings().getUrl();
            if (JGitConnector$.MODULE$.isFileRepo(url)) break block3;
            JGitConnector$.MODULE$.verifyRepositoryPath(url);
            if (remoteValidations) {
                JGitConnector$.MODULE$.verifyRemoteBranch(url, config.branch());
            }
        }
    }

    private void validateSpecification(String spec) {
        Regex taggedValueRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(":\\s*!value\\b"));
        if (taggedValueRegex.findFirstMatchIn((CharSequence)spec).isDefined()) {
            throw new ScmException("Unable to apply: '!value' tags in passwords not supported. Use variables for passwords", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    private Option<Map<String, String>> metadataMap(String folderId) {
        return new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.FOLDER().toString()), (Object)folderId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString()), (Object)this.folderAsCodeService.getFolderPath(folderId))})));
    }

    private Seq<String> extractSpecs(ScmBlobs blobs) {
        Regex SPEC_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\Rspec:"));
        String content = new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])content.split("\\R---")), (Function1 & Serializable)x$4 -> x$4.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningService.$anonfun$extractSpecs$2(SPEC_REGEX, spec)))));
    }

    private void markAsApplied(String version, FolderVersioningSettings config) {
        Date now = new Date();
        config.lastFetched_$eq(now);
        config.appliedVersion_$eq(version);
        config.appliedDate_$eq(now);
        config.appliedBy_$eq(Permissions.getAuthenticatedUserName());
        this.configurationRepository.update((BaseConfiguration)config);
    }

    private void applyScmDataToDefinitions(Seq<Definition> definitions, SCMTraceabilityData scmData) {
        Seq foldersAndCis = (Seq)definitions.withFilter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningService.$anonfun$applyScmDataToDefinitions$2(x$5))).flatMap((Function1 & Serializable)x$6 -> ((CiSpec)x$6.spec()).cis());
        Seq justCis = FolderVersioningService.flattenCis$1(foldersAndCis);
        justCis.foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            ConfigurationItem configurationItem = x0$1;
            if (configurationItem instanceof Release) {
                Release release = (Release)configurationItem;
                boxedUnit = $this.releaseService.createSCMData(release.getId(), scmData);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    private SCMTraceabilityData getScmTraceabilityData(FolderVersioningSettings config, VersionInfo versionInfo) {
        return new SCMTraceabilityData("git", String.valueOf(versionInfo.commitHash()), versionInfo.author(), new DateTime((Object)versionInfo.commitTime()), new StringBuilder(3).append("[").append(versionInfo.name()).append("] ").append(versionInfo.shortMessage()).toString(), config.gitConnection().getUrl(), FolderVersioningSettings$.MODULE$.getDefinitionsPath(config));
    }

    private String resolveFolderTitleFromId(String folderId) {
        return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findById(folderId, $this.folderService.findById$default$2())).map((Function1 & Serializable)x$7 -> x$7.getTitle()).getOrElse((Function0 & Serializable)() -> "");
    }

    public static final /* synthetic */ boolean $anonfun$extractSpecs$2(Regex SPEC_REGEX$1, String spec) {
        return !spec.isBlank() && SPEC_REGEX$1.findFirstIn((CharSequence)spec).isDefined();
    }

    private static final Seq flattenCis$1(Seq cis) {
        return (Seq)cis.flatMap((Function1 & Serializable)x0$1 -> {
            Seq seq;
            ConfigurationItem configurationItem = x0$1;
            if (configurationItem instanceof Folder) {
                Folder folder = (Folder)configurationItem;
                seq = FolderVersioningService.flattenCis$1(CollectionConverters$.MODULE$.SetHasAsScala(folder.getChildren()).asScala().toSeq());
            } else {
                seq = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigurationItem[]{configurationItem}));
            }
            return seq;
        });
    }

    public static final /* synthetic */ boolean $anonfun$applyScmDataToDefinitions$2(Definition x$5) {
        return x$5.spec() instanceof CiSpec;
    }

    @Autowired
    public FolderVersioningService(UserProfileService userProfileService, GenerateService generateService, CreationService creationService, XLRDefinitionParser definitionParser, ConfigurationRepository configurationRepository, ConfigurationVariableService configurationVariableService, ConfigurationService configurationService, FolderAsCodeService folderAsCodeService, ReleaseService releaseService, CiIdService ciIdService, FolderService folderService) {
        this.userProfileService = userProfileService;
        this.generateService = generateService;
        this.creationService = creationService;
        this.definitionParser = definitionParser;
        this.configurationRepository = configurationRepository;
        this.configurationVariableService = configurationVariableService;
        this.configurationService = configurationService;
        this.folderAsCodeService = folderAsCodeService;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.folderService = folderService;
        Logging.$init$((Logging)this);
        this.ciType = Type.valueOf(FolderVersioningSettings.class);
    }
}

