/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.api.v1.TriggersApi;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.ConfigurationItemUtils$;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import com.xebialabs.xltype.serialization.CiReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\b\u0011\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!!\u0019\u0001\t\u0013\t)\bC\u0004\u0002\u0002\u0002!I!a!\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003S\u0003A\u0011BAV\u0011\u001d\t9\f\u0001C\u0005\u0003s\u0013A\u0003\u0016:jO\u001e,'/Q:D_\u0012,7+\u001a:wS\u000e,'BA\t\u0013\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0005\u000b\u0002\r\u0005\u001c8m\u001c3f\u0015\t)b#A\u0005yYJ,G.Z1tK*\u0011q\u0003G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!G\u0001\u0004G>l7\u0001A\n\u0004\u0001q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)1\u000f\u001c45U*\tq%\u0001\u0005he&T(\u0010\\3e\u0013\tICEA\u0004M_\u001e<\u0017N\\4\u0002\u0017Q\u0014\u0018nZ4feN\f\u0005/\u001b\t\u0003YEj\u0011!\f\u0006\u0003]=\n!A^\u0019\u000b\u0005A\"\u0012aA1qS&\u0011!'\f\u0002\f)JLwmZ3sg\u0006\u0003\u0018.A\tue&<w-\u001a:SKB|7/\u001b;pef\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002:m\t\tBK]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0002\u001dI,G.Z1tKN+'O^5dKB\u0011AHP\u0007\u0002{)\u0011\u0011\u0003F\u0005\u0003\u007fu\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW-A\bsK\u001a,'/\u001a8dKN{GN^3s!\t\u00115)D\u0001\u0011\u0013\t!\u0005CA\bSK\u001a,'/\u001a8dKN{GN^3s\u0003\u0019a\u0014N\\5u}Q)q\tS%K\u0017B\u0011!\t\u0001\u0005\u0006U\u0015\u0001\ra\u000b\u0005\u0006g\u0015\u0001\r\u0001\u000e\u0005\u0006u\u0015\u0001\ra\u000f\u0005\u0006\u0001\u0016\u0001\r!\u0011\u0015\u0003\u000b5\u0003\"AT-\u000e\u0003=S!\u0001U)\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002S'\u00069a-Y2u_JL(B\u0001+V\u0003\u0015\u0011W-\u00198t\u0015\t1v+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0016aA8sO&\u0011!l\u0014\u0002\n\u0003V$xn^5sK\u0012\fQc\u0019:fCR,'+\u001a7fCN,GK]5hO\u0016\u00148\u000fF\u0006^\u0003#\ti\"a\n\u00028\u00055\u0003\u0003B\u000f_AJL!a\u0018\u0010\u0003\rQ+\b\u000f\\33!\r\t\u0017\u000e\u001c\b\u0003E\u001et!a\u00194\u000e\u0003\u0011T!!\u001a\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012B\u00015\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!A[6\u0003\t1K7\u000f\u001e\u0006\u0003Qz\u0001\"!\u001c9\u000e\u00039T!a\u001c\u000b\u0002\r\u0011|W.Y5o\u0013\t\thNA\u0004Ue&<w-\u001a:\u0011\u0007M\fYAD\u0002u\u0003\u000bq!!^@\u000f\u0005YdhBA<|\u001d\tA(P\u0004\u0002ds&\t\u0011$\u0003\u0002\u00181%\u00111CF\u0005\u0003{z\fA!_1nY*\u00111CF\u0005\u0005\u0003\u0003\t\u0019!A\u0002ei>T!! @\n\t\u0005\u001d\u0011\u0011B\u0001\u000f\u0003N\u001cu\u000eZ3SKN\u0004xN\\:f\u0015\u0011\t\t!a\u0001\n\t\u00055\u0011q\u0002\u0002\u000b\u0007\"\fgnZ3e\u0013\u0012\u001c(\u0002BA\u0004\u0003\u0013Aq!a\u0005\u0007\u0001\u0004\t)\"\u0001\u0005ue&<w-\u001a:t!\u0011\t\u0017.a\u0006\u0011\u00075\fI\"C\u0002\u0002\u001c9\u0014aBU3mK\u0006\u001cX\r\u0016:jO\u001e,'\u000fC\u0004\u0002 \u0019\u0001\r!!\t\u0002\u0011Q,W\u000e\u001d7bi\u0016\u00042!\\A\u0012\u0013\r\t)C\u001c\u0002\b%\u0016dW-Y:f\u0011\u001d\tIC\u0002a\u0001\u0003W\t\u0011B^1sS\u0006\u0014G.Z:\u0011\t\u0005L\u0017Q\u0006\t\u0005\u0003_\t\u0019$\u0004\u0002\u00022)\u0019\u0011\u0011\u00068\n\t\u0005U\u0012\u0011\u0007\u0002\t-\u0006\u0014\u0018.\u00192mK\"9\u0011\u0011\b\u0004A\u0002\u0005m\u0012A\u0003:fM\u0016\u0014XM\\2fgB!\u0011-[A\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nQb]3sS\u0006d\u0017N_1uS>t'bAA$-\u00051\u0001\u0010\u001c;za\u0016LA!a\u0013\u0002B\tY1)\u001b*fM\u0016\u0014XM\\2f\u0011\u001d\tyE\u0002a\u0001\u0003#\nA\u0002]1sK:$hi\u001c7eKJ\u0004B!a\u0015\u0002\\9!\u0011QKA,!\t\u0019g$C\u0002\u0002Zy\ta\u0001\u0015:fI\u00164\u0017\u0002BA/\u0003?\u0012aa\u0015;sS:<'bAA-=\u0005i1M]3bi\u0016$&/[4hKJ$rA]A3\u0003S\nY\u0007\u0003\u0004\u0002h\u001d\u0001\r\u0001\\\u0001\biJLwmZ3s\u0011\u001d\tId\u0002a\u0001\u0003wAq!!\u001c\b\u0001\u0004\ty'\u0001\u0005g_2$WM]%e!\u0015i\u0012\u0011OA)\u0013\r\t\u0019H\b\u0002\u0007\u001fB$\u0018n\u001c8\u0015\r\u0005]\u0014QPA@!\u0015i\u0012\u0011\u00107m\u0013\r\tYH\b\u0002\n\rVt7\r^5p]FBq!!\u000f\t\u0001\u0004\tY\u0004C\u0004\u0002P!\u0001\r!!\u0015\u0002\u001bU\u0004H-\u0019;f)JLwmZ3s)\u0019\t))a#\u0002\u000eB1Q$a\"mY2L1!!#\u001f\u0005%1UO\\2uS>t'\u0007C\u0004\u0002:%\u0001\r!a\u000f\t\u000f\u0005=\u0013\u00021\u0001\u0002R\u0005aa-\u001b8e)\u0016l\u0007\u000f\\1uKR1\u0011\u0011EAJ\u0003/Cq!!&\u000b\u0001\u0004\t\t&A\u0005jI>\u0013H+\u001b;mK\"9\u0011q\n\u0006A\u0002\u0005E\u0013\u0001\u00054j]\u0012$V-\u001c9mCR,')_%e)\u0019\t\t#!(\u0002 \"9\u0011QS\u0006A\u0002\u0005E\u0003bBA(\u0017\u0001\u0007\u0011\u0011K\u0001\u0014M&tG\rV3na2\fG/\u001a\"z)&$H.\u001a\u000b\u0007\u0003C\t)+a*\t\u000f\u0005UE\u00021\u0001\u0002R!9\u0011q\n\u0007A\u0002\u0005E\u0013A\u0006<bY&$\u0017\r^3Ti>\u0014X\r\u001a+sS\u001e<WM]:\u0015\t\u00055\u00161\u0017\t\u0004;\u0005=\u0016bAAY=\t!QK\\5u\u0011\u0019\t),\u0004a\u0001A\u0006q1\u000f^8sK\u0012$&/[4hKJ\u001c\u0018\u0001G;qI\u0006$X\r\u0016:jO\u001e,'o\u001d)s_B,'\u000f^5fgR1\u0011QVA^\u0003{Ca!a\u001a\u000f\u0001\u0004a\u0007bBA(\u001d\u0001\u0007\u0011\u0011\u000b\u0015\u0004\u0001\u0005\u0005\u0007\u0003BAb\u0003\u0013l!!!2\u000b\u0007\u0005\u001dW+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a3\u0002F\n91+\u001a:wS\u000e,\u0007")
public class TriggerAsCodeService
implements Logging {
    private final TriggersApi triggersApi;
    private final TriggerRepository triggerRepository;
    private final ReleaseService releaseService;
    private final ReferenceSolver referenceSolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerAsCodeService triggerAsCodeService = this;
        synchronized (triggerAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<List<Trigger>, AsCodeResponse.ChangedIds> createReleaseTriggers(List<ReleaseTrigger> triggers, Release template, List<Variable> variables, List<CiReference> references, String parentFolder) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Processing triggers for container ").append(template.getTitle()).append(": ").append(triggers).toString());
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            java.util.List triggerList = $this.triggerRepository.findByTemplateId(template.getId(), (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent();
            return ((TraversableOnce)((TraversableLike)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(triggerList).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$createReleaseTriggers$3(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> (ReleaseTrigger)x$2, Buffer$.MODULE$.canBuildFrom())).toList();
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List storedTriggers = (List)success.value();
            triggers.foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                TriggerAsCodeService.$anonfun$createReleaseTriggers$5(references, variables, template, trigger);
                return BoxedUnit.UNIT;
            });
            this.validateStoredTriggers((List<Trigger>)storedTriggers);
            Tuple3<List<Trigger>, AsCodeResponse.ChangedIds, List<Trigger>> tuple3 = ConfigurationItemUtils$.MODULE$.createCis(triggers, storedTriggers, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.getTitle(), this.createTrigger(references, parentFolder), this.updateTrigger(references, parentFolder));
            if (tuple3 == null) throw new MatchError(tuple3);
            List createdTriggers = (List)tuple3._1();
            AsCodeResponse.ChangedIds triggerChangedCis = (AsCodeResponse.ChangedIds)tuple3._2();
            Tuple2 tuple2 = new Tuple2((Object)createdTriggers, (Object)triggerChangedCis);
            Tuple2 tuple22 = tuple2;
            List createdTriggers2 = (List)tuple22._1();
            AsCodeResponse.ChangedIds triggerChangedCis2 = (AsCodeResponse.ChangedIds)tuple22._2();
            return new Tuple2((Object)createdTriggers2, (Object)triggerChangedCis2);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof PermissionDeniedException && triggers.isEmpty()) {
                return new Tuple2((Object)List$.MODULE$.empty(), (Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids());
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable ex = failure.exception();
        throw ex;
    }

    public AsCodeResponse.ChangedIds createTrigger(Trigger trigger, List<CiReference> references, Option<String> folderId) {
        String parentFolder = (String)folderId.getOrElse((Function0 & Serializable & scala.Serializable)() -> "/");
        List storedTriggers = ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.triggerRepository.findByFolderId(parentFolder, false, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).toList();
        this.validateStoredTriggers((List<Trigger>)storedTriggers);
        return (AsCodeResponse.ChangedIds)ConfigurationItemUtils$.MODULE$.createCis(new .colon.colon((Object)trigger, (List)Nil$.MODULE$), storedTriggers, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), this.createTrigger(references, parentFolder), this.updateTrigger(references, parentFolder))._2();
    }

    private Function1<Trigger, Trigger> createTrigger(List<CiReference> references, String parentFolder) {
        return (Function1 & Serializable & scala.Serializable)trigger -> {
            $this.referenceSolver.resolveReferences((ConfigurationItem)trigger, references, parentFolder);
            this.updateTriggersProperties((Trigger)trigger, parentFolder);
            return $this.triggersApi.addTrigger(trigger);
        };
    }

    private Function2<Trigger, Trigger, Trigger> updateTrigger(List<CiReference> references, String parentFolder) {
        return (Function2 & Serializable & scala.Serializable)(existingTrigger, updatedTrigger) -> {
            $this.referenceSolver.resolveReferences((ConfigurationItem)updatedTrigger, references, parentFolder);
            this.updateTriggersProperties((Trigger)updatedTrigger, parentFolder);
            return $this.triggersApi.updateTrigger(existingTrigger.getId(), updatedTrigger);
        };
    }

    private Release findTemplate(String idOrTitle, String parentFolder) {
        return Ids.isReleaseId((String)idOrTitle) ? this.findTemplateById(idOrTitle, parentFolder) : this.findTemplateByTitle(idOrTitle, parentFolder);
    }

    private Release findTemplateById(String idOrTitle, String parentFolder) {
        Release release;
        try {
            release = this.releaseService.findById(idOrTitle);
        }
        catch (LogFriendlyNotFoundException nfe) {
            release = this.findTemplateByTitle(idOrTitle, parentFolder);
        }
        catch (Exception e) {
            throw new AsCodeException(new StringBuilder(37).append("Failed to find template [").append(idOrTitle).append("], error [").append(e.getMessage()).append("].").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return release;
    }

    private Release findTemplateByTitle(String idOrTitle, String parentFolder) {
        Release template;
        block6: {
            List list;
            boolean bl;
            block5: {
                bl = false;
                .colon.colon colon2 = null;
                list = ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.releaseService.findTemplatesByTitle(parentFolder, idOrTitle, 0, 2, 1)).toList();
                if (!(list instanceof .colon.colon)) break block5;
                bl = true;
                colon2 = (.colon.colon)list;
                template = (Release)colon2.head();
                List list2 = colon2.tl$access$1();
                if (Nil$.MODULE$.equals(list2)) break block6;
            }
            if (bl) {
                throw new AsCodeException(new StringBuilder(91).append("More than one template with name [").append(idOrTitle).append("] is present in the folder [").append(parentFolder).append("]. Please use an unique name.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            if (Nil$.MODULE$.equals(list)) {
                throw new AsCodeException(new StringBuilder(49).append("There is no template with name [").append(idOrTitle).append("] under folder [").append(parentFolder).append("]").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)list);
        }
        Release release = template;
        return release;
    }

    private void validateStoredTriggers(List<Trigger> storedTriggers) {
        ((IterableLike)storedTriggers.groupBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle()).values().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$validateStoredTriggers$2(x$7)))).foreach((Function1 & Serializable & scala.Serializable)triggerGroup -> {
            Trigger trigger = (Trigger)triggerGroup.head();
            throw new AsCodeException(new StringBuilder(99).append("More than one trigger with the name [").append(trigger.getTitle()).append("] is present in the repository. Don't know which one to update").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    private void updateTriggersProperties(Trigger trigger, String parentFolder) {
        trigger.setFolderId(parentFolder);
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            releaseTrigger.setTemplate(this.findTemplate(releaseTrigger.getTemplate(), parentFolder).getId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(eventBasedTrigger.mappedProperties()).find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$1(p))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MappedProperty mappedProperty = x0$1;
                if (!(mappedProperty instanceof MappedProperty.StringValue)) {
                    throw new MatchError((Object)mappedProperty);
                }
                MappedProperty.StringValue stringValue = (MappedProperty.StringValue)mappedProperty;
                Release release = this.findTemplate(stringValue.value(), parentFolder);
                return release;
            }).map((Function1 & Serializable & scala.Serializable)templateId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$3(eventBasedTrigger, templateId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "template";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
    }

    public static final /* synthetic */ boolean $anonfun$createReleaseTriggers$3(Trigger x$1) {
        return x$1.getType().isSubTypeOf(Type.valueOf(ReleaseTrigger.class));
    }

    public static final /* synthetic */ void $anonfun$createReleaseTriggers$5(List references$1, List variables$1, Release template$1, ReleaseTrigger trigger) {
        Utils$.MODULE$.checkRequiredCiFields(trigger, (List<CiReference>)references$1);
        Utils$.MODULE$.checkIfTriggerVariablesAreCorrect((List<Variable>)variables$1, (List<Variable>)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(trigger.getVariables()).toList(), trigger.getTitle());
        trigger.setTemplate(template$1.getId());
    }

    public static final /* synthetic */ boolean $anonfun$validateStoredTriggers$2(List x$7) {
        return x$7.length() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$1(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "template";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$3(EventBasedTrigger x3$1, Release templateId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("templateId");
        value.setValue(templateId.getId());
        return x3$1.mappedProperties().add(value);
    }

    @Autowired
    public TriggerAsCodeService(TriggersApi triggersApi, TriggerRepository triggerRepository, ReleaseService releaseService, ReferenceSolver referenceSolver) {
        this.triggersApi = triggersApi;
        this.triggerRepository = triggerRepository;
        this.releaseService = releaseService;
        this.referenceSolver = referenceSolver;
        Logging.$init$((Logging)this);
    }
}

