let listSelector = undefined;
class TriggersPage {
    static initClass() {
        listSelector = ".trigger-list";
    }

    constructor() {
        Browser.waitFor(listSelector);
    }

    setAllowConcurrentReleasesFromTriggerAndSubmit(checked) {
        const checkbox = element(By.css('form[name="releaseTriggerOptions"] label[for="cb"]'));
        if (checkbox.getAttribute('checked') !== checked) {
            checkbox.click();
        }
        return this;
    }

    expectAllowConcurrentReleasesFromTrigger(expectedValue) {
        let selector = 'form[name="releaseTriggerOptions"] input[type="checkbox"]';
        if (expectedValue) {
            selector += ":checked";
        } else {
            selector += ":not(:checked)";
        }

        expect(element.all(By.$(selector)).count() !== 0).toBeTruthy();
        return this;
    }

    expectTriggersVisible(amount) {
        expect(element.all(By.css('.xlr-trigger-row .trigger-row-content')).count()).toBe(amount);
        return this;
    }

    expectNoNewTriggerButtonShown() {
        browser.sleep(10000);
        expect(element(By.$(".trigger-header a.button.primary"))).toBePresent(false);
        return this;
    }

    goOnRelatedReleasesOf(triggerId) {
        browser.setLocation(`/releases?tags=${triggerId}`);
        return new ReleasesListPage();
    }

}
TriggersPage.initClass();

global.TriggersPage = TriggersPage;
