class DipMapStringString {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
        this.mapStringString = element(By.$(this.path));
        this.keyClass = '.input-key';
        this.valueClass = '.input-value';
    }

    setKey(key) {
        this.clearKey();
        this.enter(this.keyClass, key);
        return this;
    }

    setValue(value) {
        this.clearValue();
        this.enter(this.valueClass, value);
        return this;
    }

    focus(selector) {
        this.mapStringString.element(By.css(selector)).click();
        return this;
    }

    enter(elementClass, text) {
        this.mapStringString.element(By.css(elementClass)).sendKeys(text);
        return this;
    }

    getInput() {
        let key = this.mapStringString.element(By.css(this.keyClass)).getText();
        let value = this.mapStringString.element(By.css(this.valueClass)).getText();
        return [key, value];
    }

    removeFirstItem() {
        Browser.scrollTo(By.$(".table-scrollable-container td div.xl-btn-close:first"));
        this.mapStringString.element(By.$(".table-scrollable-container td div.xl-btn-close:first")).click();
        return this;
    }

    removeItem(text) {
        this.mapStringString.element(By.$(`.table-scrollable-container tr:contains('${text}') .xl-btn-close`)).click();
        return this;
    }

    clearInput() {
        this.clearKey();
        return this.clearValue();
    }

    clearKey() {
        this.mapStringString.element(By.css(this.keyClass)).clear();
        return this;
    }

    clearValue() {
        this.mapStringString.element(By.css(this.valueClass)).clear();
        return this;
    }

    add(key, value) {
        this.setKey(key);
        this.setValue(value);
        this.mapStringString.element(By.css(".xl-map-string-string-div-buttons .xl-button")).click();
        return this;
    }

    expectAddIsDisabled(isDisabled = 'true', description = 'Add button should be disabled') {
        let addBtnDisabled = this.mapStringString.element(By.$(".xl-map-string-string-div-buttons:contains('Add') .xl-button")).getAttribute('disabled');
        let disabled = addBtnDisabled.then(disabled => disabled != null ? disabled : 'false');
        expect(disabled).toBe(isDisabled, description);
        return this;
    }

    expectAddIsEnabled() {
        this.expectAddIsDisabled('false', 'Add button should be enabled');
        return this;
    }

    getItems() {
        return this.mapStringString.all(By.css(".table-scrollable-container .table-scrollable table tbody tr"));
    }

    shouldHaveSize(expectedSize) {
        expect(this.getItems().count()).toBe(expectedSize, `Should contain ${expectedSize} item(s)`);
        return this;
    }

    shouldHaveItems(expectedItems) {
        this.shouldHaveSize(Object.keys(expectedItems).length);
        this.getItems().then(items =>
            items.map((item) =>
                item.element(By.css('.xl-map-key')).getText().then(key => expect(item.element(By.css('.xl-map-value')).getText()).toBe(expectedItems[key]))));
        return this;
    }
}


global.DipMapStringString = DipMapStringString;
