class FolderExplorerPage {
    static initClass() {
        this;
    }

    static delete(folderTitle) {
        let button;
        element(By.$(`.ui-grid-row:contains(${folderTitle}) .link:contains('Delete')`)).click();
        return element(By.$(button = "button.primary")).click();
    }

    static goToExplorer() {
        browser.setLocation("/folders");
        return this;
    }

    static goToFolder(folderId) {
        browser.setLocation(`/folders/Applications/${folderId}/templates`);
        Browser.waitFor('.ui-grid-row-selected');
        browser.sleep(300);
        return this;
    }

    static openFolder(folderName) {
        element(By.$(`.ui-grid-row-title:contains(${folderName})`)).click();
        return new FolderDetailsPage();
    }

    static expandWest() {
        Browser.waitForDisplayed('.toggler.toggler-expand');
        element(By.$(".toggler.toggler-expand")).click();
        return this;
    }

    static expandEast() {
        Browser.waitForDisplayed('.toggler.toggler-collapse');
        element(By.$(".toggler.toggler-collapse")).click();
        return this;
    }

    static expectCreateFolderButtonName(text) {
        expect(element(By.$(".folder-list span.create-new-folder")).getText()).toContain(text);
        return this;
    }

    static expectSearchInputCondition(condition, width) {
        element(By.$(".search-filter")).getSize().then(function (size) {
            switch (condition) {
                case 'lt':
                    expect(size.width).toBeLessThan(width);
                case 'eq':
                    expect(size.width).toEqual(width);
            }
        });
        return this;
    }

    static expectRowContainsActions(condition) {
        expect(element(By.$('.ui-grid-row-selected .action:contains("Delete")'))).toBePresent(condition);
        return this;
    }

    static expectRowIsSelected(condition) {
        expect(element(By.$('.ui-grid-row-selected'))).toBePresent(condition);
        return this;
    }

    static createNewFolder(folderId) {
        element(By.$(".folder-list span.create-new-folder")).click();
        element(By.$("[name='createFolderForm'] #folder-name")).sendKeys(folderId);
        element(By.$(".modal-dialog .button.continue")).click();
        return this;
    }

    static expandFolderRow(folderName) {
        // this is a workaround so the test passes on Chrome...
        const toggleIcon = element(By.$(`.ui-grid-row:contains(${folderName}) .toggle-icon`));
        browser.executeScript('arguments[0].click();', toggleIcon.getWebElement());
        return this;
    }

    static expectContainsFolderRow(folderName, condition) {
        expect(element(By.$(`.ui-grid-row:contains(${folderName})`))).toBePresent(condition);
        return this;
    }

    static searchFolder(folderName) {
        element(By.css('.folder-list .search-filter')).sendKeys(folderName);
        return this;
    }

    static deleteFolderFromFullView(folderName) {
        Browser.waitForDisplayed(`.ui-grid-row:contains(${folderName}) .action:contains(Delete) .link`);
        element(By.$(`.ui-grid-row:contains(${folderName}) .action:contains(Delete) .link`)).click();
        Browser.waitForDisplayed(".modal-dialog button.primary:contains(Delete)");
        element(By.$(".modal-dialog button.primary:contains(Delete)")).click();
        return this;
    }

    static expectNoFolderContent() {
        expect(element(By.$('.no-folders:contains("There are no folders here yet. Would you like to create one?")'))).toBePresent(true);
        expect(element(By.$('.no-folders span.new-folder-button:contains(Add folder)'))).toBePresent(true);
    }

    static showPopup() {
        element(By.$(".ui-grid-row-selected .options-icon")).click();
        browser.sleep(700);
        return this;
    }

    static waitForContextMenu() {
        return Browser.waitFor(".options-icon");
    }

    static expectPopupContainsCorrectItems() {
        const items = ['Add folder', 'Rename', 'Delete'];
        for (const item of items) {
            expect(element(By.$(`xlr-context-menu a:contains(${item})`))).toBePresent(true);
        }
        return this;
    }

    static createNewFolderFromPopup(folderId) {
        element(By.$("xlr-context-menu a:contains(Add folder)")).click();
        element(By.$("[name='createFolderForm'] #folder-name")).sendKeys(folderId);
        element(By.$(".modal-dialog .button.continue")).click();
        return this;
    }

    static renameFolderFromPopup(folderName) {
        element(By.$("xlr-context-menu a:contains(Rename)")).click();
        // looks like .clear method results in blur, which effectively makes
        // editbox disappear in this case.
        element(By.$(".folder-name-input")).sendKeys('\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08', folderName, protractor.Key.ENTER);
        return this;
    }

    static deleteFolderFromPopup() {
        element(By.$("xlr-context-menu a:contains(Delete)")).click();
        element(By.$(".modal-dialog button.primary")).click();
        return this;
    }

    static renameFolderFromFullView(folderToRename, folderName) {
        Browser.waitForDisplayed(`.ui-grid-row:contains(${folderToRename}) .action:contains(Rename) .link`);
        element(By.$(`.ui-grid-row:contains(${folderToRename}) .action:contains(Rename) .link`)).click();
        browser.sleep(200);
        Browser.waitForDisplayed(".folder-name-input");
        element(By.$(".folder-name-input")).sendKeys('\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08', folderName, protractor.Key.ENTER);
        browser.sleep(300);
        return this;
    }

    static createNewFolderFromFullView(parentFolder, folderName) {
        Browser.waitForDisplayed(`.ui-grid-row:contains(${parentFolder}) .action:contains(Add folder) .link`);
        element(By.$(`.ui-grid-row:contains(${parentFolder}) .action:contains(Add folder) .link`)).click();
        element(By.$("[name='createFolderForm'] #folder-name")).sendKeys(folderName);
        element(By.$(".modal-dialog .button.continue")).click();
        return this;
    }

    static expectAddFolderButtonEnabled(enabled = true) {
        expect(element(By.$(".folder-list span.create-new-folder")).getAttribute('disabled')).toBe(`${!enabled}`);
        return this;
    }

    static expectFolderRenameErrorDialogShown(newName) {
        expect(element(By.$('.modal-title:contains(Rename Folder)'))).toBePresent(true);
        expect(element(By.$(`.modal-body:contains(The name ${newName} is already in use. Please choose another name.)`))).toBePresent(true);
    }

    static expectValidationErrorShown(text) {
        expect(element(By.$(`.modal-body .field-errors:contains(${text})`))).toBePresent(true);
    }
}
FolderExplorerPage.initClass();

global.FolderExplorerPage = FolderExplorerPage;
