class AddTemplateDropdown {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
    }

    open() {
        element(By.css(`${this.path} .btn-group button`)).click();
        return this;
    }

    create() {
        this.open();
        element(By.css(`${this.path} .dropdown-menu .create-template`)).click();
        return new TemplatePropertiesPage();
    }

    move() {
        this.open();
        return element(By.css(`${this.path} .move-template`)).click();
    }

    import() {
        this.open();
        element(By.css(`${this.path} .import-template`)).click();
        return new ImportTemplateDialog();
    }
}

global.AddTemplateDropdown = AddTemplateDropdown;
