let formSelector = undefined;

class TriggerEditPage {
    static initClass() {
        formSelector = "[name='triggerForm']";
    }

    fillFormAndSubmit(fields) {
        this.fillForm(fields);
        return this.submit();
    }

    getAutocomplete(field) {
        return new XlWidgetAutocomplete(`#${field}`);
    }

    fillAutocompleteField(field, value) {
        this.getAutocomplete(field).focus().select(value, true);
        browser.actions().sendKeys(protractor.Key.ENTER).perform();
        return this;
    }

    fillSelectField(field, value) {
        new InlineEditor(`${formSelector} #${field}`).select(value);
        return this;
    }

    fillVariable(variable, value) {
        let editor = new InlineEditor(`div.form-group:contains(${variable})`);
        editor.set(value);
        return this;
    }

    setEnabled(value) {
        element(By.$(`${formSelector} #enabled`)).isSelected().then(function (selected) {
            if (selected !== value) {
                return element(By.$(`${formSelector} #enabled`)).click();
            }
        });
        return this;
    }

    fillForm(fields) {
        if (fields instanceof Object) {
            for (let k in fields) {
                let v = fields[k];
                if (_.isNumber(v)) {
                    FormUtil.setField(`${formSelector} #${k}`, v);
                } else {
                    element(By.$(`${formSelector} #${k}`)).clear();
                    element(By.$(`${formSelector} #${k}`)).sendKeys(`${v}`);
                }
            }
        }
        return this;
    }

    submit() {
        element(By.$(`#release-header #submit`)).click();
        Browser.waitFor('#triggers-settings');
        return new TriggersPage();
    }
}

TriggerEditPage.initClass();

global.TriggerEditPage = TriggerEditPage;
