class RiskProfilePage {
    constructor() {
        Browser.waitFor('#risk-settings');
        browser.waitForAngular(); // alternative wait for risk-profile-title?
    }

    shouldBeEditable(editable) {
        expect(element(by.id('submit')).isEnabled()).toBe(editable);
    }

    setName(name) {
        Browser.waitFor('#riskProfileTitle');
        const input = element(by.id('riskProfileTitle'));
        input.clear();
        input.sendKeys(name);
        return this;
    }

    expectName(name) {
        Browser.waitFor('#riskProfileTitle');
        expect(element(by.id('riskProfileTitle')).getAttribute('value')).toEqual(name);
        return this;
    }

    save() {
        element(by.id('submit')).click();
        return new RiskProfilePage();
    }

    cancel() {
        element(by.css('.button.cancel')).click();
        return new RisksPage();
    }
}

global.RiskProfilePage = RiskProfilePage;
