class ReleaseValueStreamPage {
    constructor() {
        Browser.waitFor('#release-value-stream');
    }

    filter({timeFrame, title, tag}) {
        if (timeFrame) {
            element(By.$(`.time-frame button[ng-click*='${timeFrame}']`)).click();
        }
        if (title) {
            element(By.css("#searchFilter")).clear();
            element(By.css("#searchFilter")).sendKeys(title);
            browser.sleep(700);
        }
        if (tag) {
            new TagEditor('.tags').addTag(tag);
        }
        browser.waitForAngular();
        return new ReleaseValueStreamPage();
    }

    getRelease(releaseName) {
        return new ReleaseValueStream(`.release:contains('${releaseName}')`);
    }

    expectReleaseNotDisplayed(releaseName) {
        expect(element(By.$(`.release:contains('${releaseName}')`)).isPresent()).toBe(false);
        return this;
    }

    expectReleaseDisplayed(releaseName) {
        expect(element(By.$(`.release:contains('${releaseName}')`)).isPresent()).toBe(true);
        return this;
    }
}

class ReleaseValueStream {
    constructor(releaseSelector) {
        this.releaseSelector = releaseSelector;
    }

    expectDuration(duration) {
        expect(element(By.$(`${this.releaseSelector} .release-details`)).getText()).toContain(duration);
        return this;
    }

    getPhase(title) {
        return new PhaseValueStream(`${this.releaseSelector} .phase:contains('${title}')`);
    }
}


class PhaseValueStream {
    constructor(phaseSelector) {
        this.phaseSelector = phaseSelector;
    }

    expectFlagged(number) {
        expect(element(By.$(`${this.phaseSelector} .flag-count`)).getText()).toContain(number);
        return this;
    }

    expectFailures(number) {
        expect(element(By.$(`${this.phaseSelector} .failure-count`)).getText()).toContain(number);
        return this;
    }

    expectDelays(number) {
        expect(element(By.$(`${this.phaseSelector} .delay-count`)).getText()).toContain(number);
        return this;
    }
}

global.ReleaseValueStreamPage = ReleaseValueStreamPage;
